/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.logic;

import java.io.Serializable;

public class RuleInterval
implements Comparable<RuleInterval>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5167641541768459775L;
    public int id;
    public int startPos;
    public int endPos;
    public double coverage;

    public RuleInterval() {
        this.id = -1;
        this.startPos = -1;
        this.endPos = -1;
    }

    public RuleInterval(int startPos, int endPos) {
        this.id = -1;
        this.startPos = startPos;
        this.endPos = endPos;
        this.coverage = Double.NaN;
    }

    public RuleInterval(int id, int startPos, int endPos, double coverage) {
        this.id = id;
        this.startPos = startPos;
        this.endPos = endPos;
        this.coverage = coverage;
    }

    public void setId(int ruleIndex) {
        this.id = ruleIndex;
    }

    public int getId() {
        return this.id;
    }

    public void setStart(int startPos) {
        this.startPos = startPos;
    }

    public int getStart() {
        return this.startPos;
    }

    public void setEnd(int endPos) {
        this.endPos = endPos;
    }

    public int getEnd() {
        return this.endPos;
    }

    public void setCoverage(double coverage) {
        this.coverage = coverage;
    }

    public double getCoverage() {
        return this.coverage;
    }

    public int getLength() {
        return this.endPos - this.startPos;
    }

    public String toString() {
        return "[" + this.startPos + "-" + this.endPos + "]";
    }

    @Override
    public int compareTo(RuleInterval arg0) {
        return Integer.compare(this.getLength(), arg0.getLength());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.coverage);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.endPos;
        result = 31 * result + this.id;
        result = 31 * result + this.startPos;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleInterval other = (RuleInterval)obj;
        if (Double.doubleToLongBits(this.coverage) != Double.doubleToLongBits(other.coverage)) {
            return false;
        }
        if (this.endPos != other.endPos) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return this.startPos == other.startPos;
    }

    public Object clone() throws CloneNotSupportedException {
        RuleInterval clone = (RuleInterval)super.clone();
        clone.id = this.id;
        clone.startPos = this.startPos;
        clone.endPos = this.endPos;
        clone.coverage = this.coverage;
        return clone;
    }
}

