/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.repair;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import net.seninp.gi.repair.RePairGrammar;
import net.seninp.gi.repair.RePairGuard;
import net.seninp.gi.repair.RePairRule;
import net.seninp.gi.repair.RePairSymbol;
import net.seninp.gi.repair.RePairSymbolRecord;
import net.seninp.gi.repair.RepairDigramRecord;
import net.seninp.gi.repair.RepairPriorityQueue;
import net.seninp.jmotif.sax.SAXProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRepair {
    private static final String SPACE = " ";
    private static final Logger LOGGER = LoggerFactory.getLogger(NewRepair.class);

    public static RePairGrammar parse(String inputStr) {
        RepairDigramRecord repairDigramRecord;
        Date start0 = new Date();
        LOGGER.debug("input string (" + String.valueOf(NewRepair.countSpaces(inputStr) + 1) + " tokens) ");
        RePairGrammar grammar = new RePairGrammar();
        ArrayList<RePairSymbolRecord> symbolizedString = new ArrayList<RePairSymbolRecord>(NewRepair.countSpaces(inputStr) + 1);
        RepairPriorityQueue digramsQueue = new RepairPriorityQueue();
        HashMap digramsTable = new HashMap();
        StringTokenizer st = new StringTokenizer(inputStr, SPACE);
        int stringPositionCounter = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            RePairSymbol symbol = new RePairSymbol(token, stringPositionCounter);
            RePairSymbolRecord rePairSymbolRecord = new RePairSymbolRecord(symbol);
            symbolizedString.add(rePairSymbolRecord);
            if (stringPositionCounter > 0) {
                StringBuffer digramStr = new StringBuffer();
                digramStr.append(((RePairSymbolRecord)symbolizedString.get(stringPositionCounter - 1)).getPayload().toString()).append(SPACE).append(((RePairSymbolRecord)symbolizedString.get(stringPositionCounter)).getPayload().toString());
                if (digramsTable.containsKey(digramStr.toString())) {
                    ((ArrayList)digramsTable.get(digramStr.toString())).add(stringPositionCounter - 1);
                } else {
                    ArrayList<Integer> arr = new ArrayList<Integer>();
                    arr.add(stringPositionCounter - 1);
                    digramsTable.put(digramStr.toString(), arr);
                }
                symbolizedString.get(stringPositionCounter - 1).setNext(rePairSymbolRecord);
                rePairSymbolRecord.setPrevious(symbolizedString.get(stringPositionCounter - 1));
            }
            ++stringPositionCounter;
        }
        Date start1 = new Date();
        LOGGER.debug("tokenized input and extracted all pairs in " + SAXProcessor.timeToString((long)start0.getTime(), (long)start1.getTime()) + ", " + digramsTable.size() + " distinct pairs found");
        for (Map.Entry entry : digramsTable.entrySet()) {
            if (((ArrayList)entry.getValue()).size() <= 1) continue;
            RepairDigramRecord dr = new RepairDigramRecord((String)entry.getKey(), ((ArrayList)entry.getValue()).size());
            digramsQueue.enqueue(dr);
        }
        Date start2 = new Date();
        Object var10_13 = null;
        while ((repairDigramRecord = digramsQueue.dequeue()) != null) {
            ArrayList occurrences = (ArrayList)digramsTable.get(repairDigramRecord.str);
            RePairSymbolRecord first = (RePairSymbolRecord)symbolizedString.get((Integer)occurrences.get(0));
            RePairSymbolRecord second = first.getNext();
            RePairRule r = new RePairRule(grammar);
            r.setFirst(first.getPayload());
            r.setSecond(second.getPayload());
            r.assignLevel();
            r.setExpandedRule(first.getPayload().toExpandedString() + SPACE + second.getPayload().toExpandedString());
            HashSet<String> newDigrams = new HashSet<String>(occurrences.size());
            ArrayList<Integer> loopOccurrences = new ArrayList<Integer>(occurrences.size());
            for (Integer i : occurrences) {
                loopOccurrences.add(i);
            }
            while (!loopOccurrences.isEmpty()) {
                String newRightDigram;
                int currentIndex = (Integer)loopOccurrences.remove(0);
                RePairSymbolRecord currentS = symbolizedString.get(currentIndex);
                RePairSymbolRecord nextS = symbolizedString.get(currentIndex).getNext();
                RePairGuard g = new RePairGuard(r);
                g.setStringPosition(currentS.getIndex());
                r.addOccurrence(currentS.getIndex());
                RePairSymbolRecord guard = new RePairSymbolRecord(g);
                symbolizedString.set(currentIndex, guard);
                RePairSymbolRecord nextNotNull = nextS.getNext();
                guard.setNext(nextNotNull);
                if (null != nextNotNull) {
                    nextNotNull.setPrevious(guard);
                }
                RePairSymbolRecord prevNotNull = currentS.getPrevious();
                guard.setPrevious(prevNotNull);
                if (null != prevNotNull) {
                    prevNotNull.setNext(guard);
                }
                if (currentIndex > 0 && null != prevNotNull) {
                    String newLeftDigram;
                    String oldLeftDigram = prevNotNull.getPayload().toString() + SPACE + currentS.getPayload().toString();
                    int newFreq = ((ArrayList)digramsTable.get(oldLeftDigram)).size() - 1;
                    ((ArrayList)digramsTable.get(oldLeftDigram)).remove((Object)prevNotNull.getIndex());
                    if (oldLeftDigram.equalsIgnoreCase(repairDigramRecord.str)) {
                        loopOccurrences.remove((Object)prevNotNull.getIndex());
                    }
                    digramsQueue.updateDigramFrequency(oldLeftDigram, newFreq);
                    if (0 == newFreq) {
                        digramsTable.remove(oldLeftDigram);
                        newDigrams.remove(oldLeftDigram);
                    }
                    if (digramsTable.containsKey(newLeftDigram = prevNotNull.getPayload().toString() + SPACE + r.toString())) {
                        ((ArrayList)digramsTable.get(newLeftDigram)).add(prevNotNull.getPayload().getStringPosition());
                    } else {
                        ArrayList<Integer> arr = new ArrayList<Integer>();
                        arr.add(prevNotNull.getPayload().getStringPosition());
                        digramsTable.put(newLeftDigram, arr);
                    }
                    newDigrams.add(newLeftDigram);
                }
                RePairSymbolRecord nextSS = nextS.getNext();
                if (currentIndex >= symbolizedString.size() - 2 || null == nextSS) continue;
                String oldRightDigram = nextS.getPayload().toString() + SPACE + nextSS.getPayload().toString();
                int newFreq = ((ArrayList)digramsTable.get(oldRightDigram)).size() - 1;
                ((ArrayList)digramsTable.get(oldRightDigram)).remove((Object)nextS.getIndex());
                if (oldRightDigram.equalsIgnoreCase(repairDigramRecord.str)) {
                    loopOccurrences.remove((Object)nextS.getIndex());
                }
                digramsQueue.updateDigramFrequency(oldRightDigram, newFreq);
                if (0 == newFreq) {
                    digramsTable.remove(oldRightDigram);
                    newDigrams.remove(oldRightDigram);
                }
                if (digramsTable.containsKey(newRightDigram = r.toString() + SPACE + nextSS.getPayload().toString())) {
                    ((ArrayList)digramsTable.get(newRightDigram)).add(currentS.getPayload().getStringPosition());
                } else {
                    ArrayList<Integer> arr = new ArrayList<Integer>();
                    arr.add(currentS.getPayload().getStringPosition());
                    digramsTable.put(newRightDigram, arr);
                }
                newDigrams.add(newRightDigram);
            }
            digramsTable.remove(repairDigramRecord.str);
            for (String digramStr : newDigrams) {
                if (((ArrayList)digramsTable.get(digramStr)).size() <= 1) continue;
                if (digramsQueue.containsDigram(digramStr)) {
                    digramsQueue.updateDigramFrequency(digramStr, ((ArrayList)digramsTable.get(digramStr)).size());
                    continue;
                }
                digramsQueue.enqueue(new RepairDigramRecord(digramStr, ((ArrayList)digramsTable.get(digramStr)).size()));
            }
        }
        Date start3 = new Date();
        LOGGER.debug("finished repair grammar construction in " + SAXProcessor.timeToString((long)start2.getTime(), (long)start3.getTime()));
        grammar.setR0String(NewRepair.asString(symbolizedString));
        grammar.setR0ExpnadedString(inputStr.substring(0));
        return grammar;
    }

    private static String asString(ArrayList<RePairSymbolRecord> symbolizedString) {
        StringBuffer res = new StringBuffer();
        RePairSymbolRecord s = symbolizedString.get(0);
        do {
            res.append(s.getPayload().toString()).append(SPACE);
        } while (null != (s = s.getNext()));
        return res.toString();
    }

    private static int countSpaces(String str) {
        if (null == str) {
            return -1;
        }
        int counter = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ' ') continue;
            ++counter;
        }
        return counter;
    }
}

