/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.repair;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import net.seninp.gi.logic.GrammarRuleRecord;
import net.seninp.gi.logic.GrammarRules;
import net.seninp.gi.logic.RuleInterval;
import net.seninp.gi.repair.RePairRule;
import net.seninp.jmotif.sax.datastructure.SAXRecords;

public class RePairGrammar {
    private static final char THE_R = 'R';
    private static final char SPACE = ' ';
    protected AtomicInteger numRules = new AtomicInteger(1);
    protected Hashtable<Integer, RePairRule> theRules = new Hashtable();
    protected String r0String;
    protected String r0ExpandedString;

    public void setR0String(String str) {
        this.r0String = str;
    }

    public String getR0CompressedString() {
        return this.r0String;
    }

    public void setR0ExpnadedString(String str) {
        this.r0ExpandedString = str;
    }

    public Hashtable<Integer, RePairRule> getRules() {
        return this.theRules;
    }

    public void expandRules() {
        for (int currentPositionIndex = 1; currentPositionIndex <= this.theRules.size(); ++currentPositionIndex) {
            RePairRule rr = this.theRules.get(currentPositionIndex);
            String resultString = rr.toRuleString();
            int currentSearchStart = resultString.indexOf(82);
            while (currentSearchStart >= 0) {
                int spaceIdx = resultString.indexOf(32, currentSearchStart);
                String ruleName = resultString.substring(currentSearchStart, spaceIdx + 1);
                Integer ruleId = Integer.valueOf(ruleName.substring(1, ruleName.length() - 1));
                RePairRule rule = this.theRules.get(ruleId);
                if (rule != null) {
                    resultString = rule.expandedRuleString.charAt(rule.expandedRuleString.length() - 1) == ' ' ? resultString.replaceAll(ruleName, rule.expandedRuleString) : resultString.replaceAll(ruleName, rule.expandedRuleString + ' ');
                }
                currentSearchStart = resultString.indexOf("R", spaceIdx);
            }
            rr.setExpandedRule(resultString.trim());
        }
        String resultString = this.r0String;
        int currentSearchStart = resultString.indexOf(82);
        while (currentSearchStart >= 0) {
            int spaceIdx = resultString.indexOf(32, currentSearchStart);
            String ruleName = resultString.substring(currentSearchStart, spaceIdx + 1);
            Integer ruleId = Integer.valueOf(ruleName.substring(1, ruleName.length() - 1));
            RePairRule rule = this.theRules.get(ruleId);
            if (rule != null) {
                resultString = rule.expandedRuleString.charAt(rule.expandedRuleString.length() - 1) == ' ' ? resultString.replaceAll(ruleName, rule.expandedRuleString) : resultString.replaceAll(ruleName, rule.expandedRuleString + ' ');
            }
            currentSearchStart = resultString.indexOf("R", spaceIdx);
        }
        this.r0ExpandedString = resultString;
    }

    public String toGrammarRules() {
        StringBuffer sb = new StringBuffer();
        System.out.println("R0 -> " + this.r0String);
        for (int i = 1; i <= this.theRules.size(); ++i) {
            RePairRule r = this.theRules.get(i);
            sb.append('R').append(r.ruleNumber).append(" -> ").append(r.toRuleString()).append(" : ").append(r.expandedRuleString).append(", ").append(r.occurrences).append("\n");
        }
        return sb.toString();
    }

    public GrammarRules toGrammarRulesData() {
        GrammarRules res = new GrammarRules();
        GrammarRuleRecord r0 = new GrammarRuleRecord();
        r0.setRuleNumber(0);
        r0.setRuleString(this.r0String);
        r0.setExpandedRuleString(this.r0ExpandedString);
        r0.setOccurrences(new int[]{0});
        r0.setMeanLength(-1);
        r0.setMinMaxLength(new int[]{-1});
        res.addRule(r0);
        for (RePairRule rule : this.theRules.values()) {
            GrammarRuleRecord rec = new GrammarRuleRecord();
            rec.setRuleNumber(rule.ruleNumber);
            rec.setRuleString(rule.toRuleString());
            rec.setExpandedRuleString(rule.expandedRuleString);
            rec.setRuleYield(RePairGrammar.countSpaces(rule.expandedRuleString));
            rec.setOccurrences(rule.getOccurrences());
            rec.setRuleIntervals(rule.getRuleIntervals());
            rec.setRuleLevel(rule.getLevel());
            rec.setMinMaxLength(rule.getLengths());
            rec.setMeanLength(RePairGrammar.mean(rule.getRuleIntervals()));
            res.addRule(rec);
        }
        for (GrammarRuleRecord r : res) {
            String[] tokens;
            String str = r.getRuleString();
            for (String t : tokens = str.split("\\s+")) {
                if (!t.startsWith("R")) continue;
                Integer ruleId = Integer.valueOf(t.substring(1));
                GrammarRuleRecord rr = res.get(ruleId);
                int newFreq = rr.getRuleUseFrequency() + 1;
                rr.setRuleUseFrequency(newFreq);
            }
        }
        return res;
    }

    public void buildIntervals(SAXRecords records, double[] originalTimeSeries, int slidingWindowSize) {
        records.buildIndex();
        for (int ruleIdx = 1; ruleIdx <= this.theRules.size(); ++ruleIdx) {
            RePairRule rr = this.theRules.get(ruleIdx);
            String[] split = rr.expandedRuleString.split(" ");
            for (int strPos : rr.getOccurrences()) {
                Integer tsPos = records.mapStringIndexToTSPosition(strPos + split.length - 1);
                if (null == tsPos) {
                    rr.ruleIntervals.add(new RuleInterval(records.mapStringIndexToTSPosition(strPos), originalTimeSeries.length + 1));
                    continue;
                }
                rr.ruleIntervals.add(new RuleInterval(records.mapStringIndexToTSPosition(strPos), records.mapStringIndexToTSPosition(strPos + split.length - 1) + slidingWindowSize));
            }
        }
    }

    private static int mean(ArrayList<RuleInterval> arrayList) {
        if (null == arrayList || arrayList.isEmpty()) {
            return 0;
        }
        int res = 0;
        int count = 0;
        for (RuleInterval ri : arrayList) {
            res += ri.getEnd() - ri.getStart();
            ++count;
        }
        return res / count;
    }

    private static int countSpaces(String str) {
        if (null == str) {
            return -1;
        }
        int counter = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ' ') continue;
            ++counter;
        }
        return counter;
    }
}

