/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.repair;

import java.util.ArrayList;
import net.seninp.gi.logic.RuleInterval;
import net.seninp.gi.repair.RePairGrammar;
import net.seninp.gi.repair.RePairSymbol;

public class RePairRule {
    private static final char SPACE = ' ';
    protected int ruleNumber;
    protected String expandedRuleString;
    protected RePairSymbol first;
    protected RePairSymbol second;
    protected int level;
    protected ArrayList<Integer> occurrences;
    protected ArrayList<RuleInterval> ruleIntervals;
    private RePairGrammar grammar;

    public RePairRule(RePairGrammar rg) {
        this.grammar = rg;
        this.ruleNumber = rg.numRules.intValue();
        rg.numRules.incrementAndGet();
        rg.theRules.put(this.ruleNumber, this);
        this.occurrences = new ArrayList();
        this.ruleIntervals = new ArrayList();
    }

    public void setFirst(RePairSymbol symbol) {
        this.first = symbol;
    }

    public RePairSymbol getFirst() {
        return this.first;
    }

    public void setSecond(RePairSymbol symbol) {
        this.second = symbol;
    }

    public RePairSymbol getSecond() {
        return this.second;
    }

    public int getId() {
        return this.ruleNumber;
    }

    public String toRuleString() {
        if (0 == this.ruleNumber) {
            return this.grammar.r0String;
        }
        return this.first.toString() + ' ' + this.second.toString() + ' ';
    }

    public void setExpandedRule(String str) {
        this.expandedRuleString = str;
    }

    public String toExpandedRuleString() {
        return this.expandedRuleString;
    }

    public void addOccurrence(int value) {
        if (!this.occurrences.contains(value)) {
            this.occurrences.add(value);
        }
    }

    public int[] getOccurrences() {
        int[] res = new int[this.occurrences.size()];
        for (int i = 0; i < this.occurrences.size(); ++i) {
            res[i] = this.occurrences.get(i);
        }
        return res;
    }

    public String toString() {
        return "R" + this.ruleNumber;
    }

    public void assignLevel() {
        int lvl = Integer.MAX_VALUE;
        lvl = Math.min(this.first.getLevel() + 1, lvl);
        this.level = lvl = Math.min(this.second.getLevel() + 1, lvl);
    }

    public int getLevel() {
        return this.level;
    }

    public ArrayList<RuleInterval> getRuleIntervals() {
        return this.ruleIntervals;
    }

    public int[] getLengths() {
        if (this.ruleIntervals.isEmpty()) {
            return new int[1];
        }
        int[] res = new int[this.ruleIntervals.size()];
        int count = 0;
        for (RuleInterval ri : this.ruleIntervals) {
            res[count] = ri.getEnd() - ri.getStart();
            ++count;
        }
        return res;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.occurrences == null ? 0 : this.occurrences.hashCode());
        result = 31 * result + this.ruleNumber;
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RePairRule other = (RePairRule)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        if (this.occurrences == null ? other.occurrences != null : !this.occurrences.equals(other.occurrences)) {
            return false;
        }
        if (this.ruleNumber != other.ruleNumber) {
            return false;
        }
        return !(this.second == null ? other.second != null : !this.second.equals(other.second));
    }

    public String toInfoString() {
        return this.toString() + " -> " + this.first.toString() + " " + this.second.toString();
    }
}

