/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.repair;

import java.util.ArrayList;
import java.util.HashMap;
import net.seninp.gi.repair.RepairDigramRecord;

public class RepairPriorityQueue {
    private RepairQueueNode head = null;
    private HashMap<String, RepairQueueNode> elements = new HashMap();

    public void enqueue(RepairDigramRecord digramRecord) {
        if (this.elements.containsKey(digramRecord.str)) {
            throw new IllegalArgumentException("Element with payload " + digramRecord.str + " already exists in the queue...");
        }
        RepairQueueNode nn = new RepairQueueNode(digramRecord);
        if (this.elements.isEmpty()) {
            this.head = nn;
        } else if (nn.getFrequency() >= this.head.getFrequency()) {
            this.head.prev = nn;
            nn.next = this.head;
            this.head = nn;
        } else {
            RepairQueueNode prevN;
            RepairQueueNode currentNode = this.head;
            while (null != currentNode.next) {
                if (nn.getFrequency() >= currentNode.getFrequency()) {
                    prevN = currentNode.prev;
                    prevN.next = nn;
                    nn.prev = prevN;
                    currentNode.prev = nn;
                    nn.next = currentNode;
                    break;
                }
                currentNode = currentNode.next;
            }
            if (null == currentNode.next) {
                if (nn.getFrequency() >= currentNode.getFrequency()) {
                    prevN = currentNode.prev;
                    prevN.next = nn;
                    nn.prev = prevN;
                    currentNode.prev = nn;
                    nn.next = currentNode;
                } else {
                    nn.prev = currentNode;
                    currentNode.next = nn;
                }
            }
        }
        this.elements.put(nn.payload.str, nn);
    }

    public RepairDigramRecord dequeue() {
        if (null != this.head) {
            RepairDigramRecord el = this.head.payload;
            this.head = this.head.next;
            if (null != this.head) {
                this.head.prev = null;
            }
            this.elements.remove(el.str);
            return el;
        }
        return null;
    }

    public int size() {
        return this.elements.size();
    }

    public RepairDigramRecord peek() {
        if (null != this.head) {
            return this.head.payload;
        }
        return null;
    }

    public boolean containsDigram(String digramStr) {
        return this.elements.containsKey(digramStr);
    }

    public RepairDigramRecord get(String key) {
        RepairQueueNode el = this.elements.get(key);
        if (null != el) {
            return el.payload;
        }
        return null;
    }

    public RepairDigramRecord updateDigramFrequency(String digram, int newFreq) {
        if (!this.elements.containsKey(digram)) {
            return null;
        }
        RepairQueueNode alteredNode = this.elements.get(digram);
        if (newFreq == alteredNode.payload.freq) {
            return alteredNode.payload;
        }
        if (2 > newFreq) {
            this.removeNodeFromList(alteredNode);
            this.elements.remove(alteredNode.payload.str);
            return null;
        }
        int oldFreq = alteredNode.payload.freq;
        alteredNode.payload.freq = newFreq;
        if (1 == this.elements.size()) {
            return alteredNode.payload;
        }
        if (newFreq > oldFreq) {
            RepairQueueNode currentNode = alteredNode.prev;
            if (null == alteredNode.prev) {
                currentNode = alteredNode.next;
            }
            this.removeNodeFromList(alteredNode);
            alteredNode.next = null;
            alteredNode.prev = null;
            while (null != currentNode && currentNode.payload.freq < alteredNode.payload.freq) {
                currentNode = currentNode.prev;
            }
            if (null == currentNode) {
                alteredNode.next = this.head;
                this.head.prev = alteredNode;
                this.head = alteredNode;
            } else if (null == currentNode.next) {
                currentNode.next = alteredNode;
                alteredNode.prev = currentNode;
            } else {
                currentNode.next.prev = alteredNode;
                alteredNode.next = currentNode.next;
                currentNode.next = alteredNode;
                alteredNode.prev = currentNode;
            }
        } else {
            if (alteredNode.next == null) {
                return alteredNode.payload;
            }
            if (this.head == alteredNode && alteredNode.payload.freq >= this.head.next.payload.freq) {
                return alteredNode.payload;
            }
            RepairQueueNode currentNode = alteredNode.next;
            this.removeNodeFromList(alteredNode);
            alteredNode.next = null;
            alteredNode.prev = null;
            while (null != currentNode.next && currentNode.payload.freq > alteredNode.payload.freq) {
                currentNode = currentNode.next;
            }
            if (null == currentNode.next) {
                if (alteredNode.payload.freq > currentNode.payload.freq) {
                    if (this.head.equals(currentNode)) {
                        alteredNode.next = currentNode;
                        currentNode.prev = alteredNode;
                        this.head = alteredNode;
                    } else {
                        alteredNode.next = currentNode;
                        alteredNode.prev = currentNode.prev;
                        currentNode.prev.next = alteredNode;
                        currentNode.prev = alteredNode;
                    }
                } else {
                    currentNode.next = alteredNode;
                    alteredNode.prev = currentNode;
                }
            } else {
                alteredNode.next = currentNode;
                alteredNode.prev = currentNode.prev;
                if (null == currentNode.prev) {
                    this.head = alteredNode;
                } else {
                    currentNode.prev.next = alteredNode;
                    currentNode.prev = alteredNode;
                }
            }
        }
        return alteredNode.payload;
    }

    public ArrayList<RepairDigramRecord> toList() {
        ArrayList<RepairDigramRecord> res = new ArrayList<RepairDigramRecord>(this.elements.size());
        RepairQueueNode cp = this.head;
        while (null != cp) {
            res.add(cp.payload);
            cp = cp.next;
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeNodeFromList(RepairQueueNode el) {
        if (null == el.prev) {
            if (null != el.next) {
                this.head = el.next;
                this.head.prev = null;
                return;
            }
            this.head = null;
            return;
        } else if (null == el.next) {
            if (null == el.prev) throw new RuntimeException("Unrecognized situation here...");
            el.prev.next = null;
            return;
        } else {
            el.prev.next = el.next;
            el.next.prev = el.prev;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("priority queue of ").append(this.elements.size()).append(" nodes:\n");
        RepairQueueNode hp = this.head;
        int nodeCounter = 0;
        while (null != hp) {
            sb.append(nodeCounter).append(": ").append(hp.payload.str).append(", ").append(hp.payload.freq);
            sb.append("|");
            if (null == hp.prev) {
                sb.append("null");
            } else {
                sb.append("ok");
            }
            sb.append("|");
            if (null == hp.next) {
                sb.append("null");
            } else {
                sb.append("ok");
            }
            sb.append("|\n");
            hp = hp.next;
            ++nodeCounter;
        }
        return sb.delete(sb.length() - 1, sb.length()).toString();
    }

    private class RepairQueueNode {
        protected RepairQueueNode prev = null;
        protected RepairQueueNode next = null;
        protected RepairDigramRecord payload = null;

        public RepairQueueNode(RepairDigramRecord digramRecord) {
            this.payload = digramRecord;
        }

        public int getFrequency() {
            return this.payload.freq;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.next == null ? 0 : this.next.hashCode());
            result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
            result = 31 * result + (this.prev == null ? 0 : this.prev.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RepairQueueNode other = (RepairQueueNode)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.next == null ? other.next != null : !this.next.equals(other.next)) {
                return false;
            }
            if (this.payload == null ? other.payload != null : !this.payload.equals(other.payload)) {
                return false;
            }
            return !(this.prev == null ? other.prev != null : !this.prev.equals(other.prev));
        }

        private RepairPriorityQueue getOuterType() {
            return RepairPriorityQueue.this;
        }
    }
}

