/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.rulepruner;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.seninp.gi.GIAlgorithm;
import net.seninp.gi.logic.GrammarRuleRecord;
import net.seninp.gi.logic.GrammarRules;
import net.seninp.gi.repair.RePairFactory;
import net.seninp.gi.repair.RePairGrammar;
import net.seninp.gi.rulepruner.RulePrunerFactory;
import net.seninp.gi.rulepruner.RulePrunerParameters;
import net.seninp.gi.rulepruner.SampledPoint;
import net.seninp.gi.sequitur.SAXRule;
import net.seninp.gi.sequitur.SequiturFactory;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import net.seninp.jmotif.sax.datastructure.SAXRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulePruner {
    private static final String COMMA = ",";
    private static final String CR = "\n";
    private static final DecimalFormat dfPercent = new DecimalFormat("0.00");
    private static final DecimalFormat dfSize = new DecimalFormat("#.0000");
    private double[] ts;
    private static final Logger LOGGER = LoggerFactory.getLogger(RulePruner.class);

    public RulePruner(double[] ts) {
        this.ts = ts;
    }

    public SampledPoint sample(int windowSize, int paaSize, int alphabetSize, GIAlgorithm giAlgorithm, NumerosityReductionStrategy nrStrategy, double nThreshold) throws Exception {
        SampledPoint res = new SampledPoint();
        StringBuffer logStr = new StringBuffer();
        logStr.append(windowSize).append(COMMA).append(paaSize).append(COMMA).append(alphabetSize).append(COMMA);
        res.setWindow(windowSize);
        res.setPAA(paaSize);
        res.setAlphabet(alphabetSize);
        SAXProcessor sp = new SAXProcessor();
        NormalAlphabet na = new NormalAlphabet();
        SAXRecords saxData = sp.ts2saxViaWindow(this.ts, windowSize, paaSize, na.getCuts(Integer.valueOf(alphabetSize)), nrStrategy, nThreshold);
        if (Thread.currentThread().isInterrupted() && null == saxData) {
            System.err.println("Sampler being interrupted, returning NULL!");
            return null;
        }
        saxData.buildIndex();
        double approximationDistance = sp.approximationDistancePAA(this.ts, windowSize, paaSize, RulePrunerParameters.SAX_NORM_THRESHOLD) + sp.approximationDistanceAlphabet(this.ts, windowSize, paaSize, alphabetSize, RulePrunerParameters.SAX_NORM_THRESHOLD);
        logStr.append(dfSize.format(approximationDistance)).append(COMMA);
        res.setApproxDist(approximationDistance);
        GrammarRules rules = new GrammarRules();
        if (GIAlgorithm.SEQUITUR.equals((Object)giAlgorithm)) {
            SAXRule r = SequiturFactory.runSequitur(saxData.getSAXString(" "));
            rules = r.toGrammarRulesData();
            SequiturFactory.updateRuleIntervals(rules, saxData, true, this.ts, windowSize, paaSize);
        } else if (GIAlgorithm.REPAIR.equals((Object)giAlgorithm)) {
            RePairGrammar grammar = RePairFactory.buildGrammar(saxData.getSAXString(" "));
            grammar.expandRules();
            grammar.buildIntervals(saxData, this.ts, windowSize);
            rules = grammar.toGrammarRulesData();
        }
        Integer grammarSize = RulePrunerFactory.computeGrammarSize(rules, paaSize);
        logStr.append(grammarSize).append(COMMA);
        logStr.append(rules.size()).append(COMMA);
        res.setGrammarSize(grammarSize);
        res.setGrammarRules(rules.size());
        GrammarRules prunedRulesSet = RulePrunerFactory.performPruning(this.ts, rules);
        Integer compressedSize = RulePrunerFactory.computeGrammarSize(prunedRulesSet, paaSize);
        logStr.append(compressedSize).append(COMMA);
        logStr.append(prunedRulesSet.size()).append(COMMA);
        res.setCompressedGrammarSize(compressedSize);
        res.setPrunedRules(prunedRulesSet.size());
        boolean[] compressedCover = new boolean[this.ts.length];
        compressedCover = RulePrunerFactory.updateRanges(compressedCover, prunedRulesSet);
        if (RulePrunerFactory.hasEmptyRanges(compressedCover)) {
            logStr.append("0").append(COMMA);
            res.setCovered(false);
        } else {
            logStr.append("1").append(COMMA);
            res.setCovered(true);
        }
        double coverage = RulePrunerFactory.computeCover(compressedCover);
        logStr.append(coverage);
        res.setCoverage(coverage);
        res.setReduction((double)prunedRulesSet.size() / (double)rules.size());
        int maxFreq = 0;
        for (GrammarRuleRecord r : prunedRulesSet) {
            if (r.getOccurrences().size() <= maxFreq) continue;
            maxFreq = r.getOccurrences().size();
        }
        res.setMaxFrequency(maxFreq);
        logStr.append(CR);
        LOGGER.info(logStr.toString().replace(CR, ""));
        return res;
    }

    static {
        dfPercent.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        dfSize.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
    }
}

