/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.rulepruner;

import java.util.Arrays;
import java.util.List;
import net.seninp.gi.logic.GrammarRuleRecord;
import net.seninp.gi.logic.GrammarRules;
import net.seninp.gi.logic.RuleInterval;
import net.seninp.gi.rulepruner.RulePruningAlgorithm;

public class RulePrunerFactory {
    public static Integer computeGrammarSize(GrammarRules rules, Integer paaSize) {
        int res = 0;
        for (GrammarRuleRecord r : rules) {
            String ruleStr = r.getRuleString();
            String[] tokens = ruleStr.split("\\s+");
            int ruleSize = RulePrunerFactory.computeRuleSize(paaSize, tokens);
            res += ruleSize;
        }
        return res;
    }

    private static int computeRuleSize(Integer paaSize, String[] tokens) {
        int ruleSize = 0;
        for (String t : tokens) {
            if (t.startsWith("R")) {
                ruleSize += 4;
                continue;
            }
            ruleSize += paaSize.intValue();
        }
        return ruleSize;
    }

    public static GrammarRules performPruning(double[] ts, GrammarRules grammarRules) {
        RulePruningAlgorithm pruner = new RulePruningAlgorithm(grammarRules, ts.length);
        pruner.pruneRules();
        return pruner.regularizePrunedRules();
    }

    public static boolean[] updateRanges(boolean[] range, List<RuleInterval> ruleIntervals) {
        boolean[] res = Arrays.copyOf(range, range.length);
        for (RuleInterval i : ruleIntervals) {
            int start = i.getStart();
            int end = i.getEnd();
            for (int j = start; j < end; ++j) {
                res[j] = true;
            }
        }
        return res;
    }

    public static boolean[] updateRanges(boolean[] range, GrammarRules grammar) {
        boolean[] res = Arrays.copyOf(range, range.length);
        for (GrammarRuleRecord r : grammar) {
            if (0 == r.getRuleNumber()) continue;
            res = RulePrunerFactory.updateRanges(res, r.getRuleIntervals());
        }
        return res;
    }

    public static double computeCover(boolean[] cover) {
        int covered = 0;
        for (boolean i : cover) {
            if (!i) continue;
            ++covered;
        }
        return (double)covered / (double)cover.length;
    }

    public static boolean isCovered(boolean[] range) {
        for (boolean i : range) {
            if (i) continue;
            return false;
        }
        return true;
    }

    public static boolean hasEmptyRanges(boolean[] range) {
        for (boolean p : range) {
            if (p) continue;
            return true;
        }
        return false;
    }
}

