/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.rulepruner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.seninp.gi.logic.GrammarRuleRecord;
import net.seninp.gi.logic.GrammarRules;
import net.seninp.gi.logic.RuleInterval;
import net.seninp.gi.rulepruner.RulePrunerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulePruningAlgorithm {
    private static Logger logger = LoggerFactory.getLogger(RulePruningAlgorithm.class);
    private GrammarRules grammarRules;
    private boolean[] range;
    private Set<Integer> usedRules;
    private Set<Integer> removedRules;

    public RulePruningAlgorithm(GrammarRules grammarRules, int tsLength) {
        this.grammarRules = grammarRules;
        this.range = new boolean[tsLength];
        this.usedRules = new HashSet<Integer>();
        this.usedRules.add(0);
        this.removedRules = new HashSet<Integer>();
    }

    public void pruneRules() {
        GrammarRuleRecord bestRule;
        while (RulePrunerFactory.hasEmptyRanges(this.range) && (bestRule = this.findRuleWithOptimalCover()) != null) {
            this.usedRules.add(bestRule.getRuleNumber());
            this.removeOverlappingRules();
            this.range = RulePrunerFactory.updateRanges(this.range, bestRule.getRuleIntervals());
        }
        if (logger.isDebugEnabled()) {
            String rulesAsStrings = Arrays.toString((Object[])this.usedRules.toArray(new Integer[this.usedRules.size()]));
            logger.debug("Best cover {}", (Object)rulesAsStrings);
        }
    }

    private GrammarRuleRecord findRuleWithOptimalCover() {
        GrammarRuleRecord bestRule = null;
        double bestDelta = -2.147483648E9;
        for (GrammarRuleRecord rule : this.grammarRules) {
            double delta;
            int id = rule.getRuleNumber();
            if (this.usedRules.contains(id) || this.removedRules.contains(id) || !((delta = this.getCoverDelta(rule)) > bestDelta)) continue;
            bestDelta = delta;
            bestRule = rule;
        }
        return bestRule;
    }

    public double getCoverDelta(GrammarRuleRecord rule) {
        int new_cover = 0;
        int overlapping_cover = 0;
        for (RuleInterval i : rule.getRuleIntervals()) {
            int start = i.getStart();
            int end = i.getEnd();
            for (int j = start; j < end; ++j) {
                if (this.range[j]) {
                    ++overlapping_cover;
                    continue;
                }
                ++new_cover;
            }
        }
        if (0 == new_cover) {
            return 0.0;
        }
        if (0 == overlapping_cover) {
            return (double)new_cover / (double)(rule.getExpandedRuleString().length() + rule.getRuleIntervals().size());
        }
        return (double)new_cover / (double)(new_cover + overlapping_cover) / (double)(rule.getExpandedRuleString().length() + rule.getRuleIntervals().size());
    }

    private void removeOverlappingRules() {
        List<RuleInterval> currentCovering = this.usedRuleCovering();
        int[] coveringCounts = this.intervalCoveringCounts(currentCovering);
        int intervalCount = 0;
        boolean continueSearch = true;
        block0: while (continueSearch) {
            continueSearch = false;
            for (int currentRuleId : this.usedRules) {
                if (0 == currentRuleId) continue;
                GrammarRuleRecord currentRule = this.grammarRules.get(currentRuleId);
                ArrayList<RuleInterval> currentRuleIntervals = currentRule.getRuleIntervals();
                if ((intervalCount -= currentRuleIntervals.size()) == 0) continue block0;
                this.removeFromCoveringCounts(coveringCounts, currentRuleIntervals);
                if (this.isCompletelyCoveredBy(coveringCounts, currentRuleIntervals)) {
                    this.usedRules.remove(currentRuleId);
                    this.removedRules.add(currentRuleId);
                    continueSearch = true;
                    continue block0;
                }
                intervalCount += currentRuleIntervals.size();
                this.updateCoveringCounts(coveringCounts, currentRuleIntervals);
                logger.trace("rule {} can't be removed", (Object)currentRule.getRuleName());
            }
        }
    }

    private List<RuleInterval> usedRuleCovering() {
        ArrayList<RuleInterval> covering = new ArrayList<RuleInterval>();
        for (int ridB : this.usedRules) {
            if (0 == ridB) continue;
            covering.addAll(this.grammarRules.get(ridB).getRuleIntervals());
        }
        return covering;
    }

    private int[] intervalCoveringCounts(List<RuleInterval> intervals) {
        int[] coveringCount = new int[this.range.length];
        this.updateCoveringCounts(coveringCount, intervals);
        return coveringCount;
    }

    private void updateCoveringCounts(int[] covering, List<RuleInterval> intervals) {
        for (RuleInterval i : intervals) {
            int j = i.getStart();
            while (j < i.getEnd()) {
                int n = j++;
                covering[n] = covering[n] + 1;
            }
        }
    }

    private void removeFromCoveringCounts(int[] covering, List<RuleInterval> intervals) {
        for (RuleInterval i : intervals) {
            int j = i.getStart();
            while (j < i.getEnd()) {
                int n = j++;
                covering[n] = covering[n] - 1;
            }
        }
    }

    private boolean isCompletelyCoveredBy(int[] isCovered, List<RuleInterval> intervals) {
        for (RuleInterval i : intervals) {
            for (int j = i.getStart(); j < i.getEnd(); ++j) {
                if (isCovered[j] != 0) continue;
                return false;
            }
        }
        return true;
    }

    public GrammarRules regularizePrunedRules() {
        GrammarRules prunedRules = new GrammarRules();
        for (Integer rId : this.usedRules) {
            StringBuilder newRuleStr = this.buildExpandedRuleString(rId);
            if (newRuleStr.length() > 0) {
                newRuleStr.delete(newRuleStr.length() - 1, newRuleStr.length());
            }
            GrammarRuleRecord regRule = this.grammarRules.get(rId);
            regRule.setRuleString(newRuleStr.toString());
            prunedRules.addRule(regRule);
        }
        if (logger.isDebugEnabled()) {
            this.logRegularizationResults();
        }
        return prunedRules;
    }

    private StringBuilder buildExpandedRuleString(Integer rId) {
        String oldRuleStr = this.grammarRules.get(rId).getRuleString();
        String[] tokens = oldRuleStr.split("\\s+");
        StringBuilder newRuleStr = new StringBuilder();
        for (String t : tokens) {
            if (t.startsWith("R")) {
                Integer ruleId = Integer.valueOf(t.substring(1));
                if (this.usedRules.contains(ruleId)) {
                    newRuleStr.append(t).append(" ");
                    continue;
                }
                logger.trace("updating the rule " + rId);
                newRuleStr.append(this.resolve(ruleId)).append(" ");
                continue;
            }
            newRuleStr.append(t).append(" ");
        }
        return newRuleStr;
    }

    private String resolve(Integer ruleId) {
        StringBuilder newRuleStr = this.buildExpandedRuleString(ruleId);
        if (newRuleStr.length() > 0) {
            newRuleStr.delete(newRuleStr.length() - 1, newRuleStr.length());
        }
        return newRuleStr.toString();
    }

    private void logRegularizationResults() {
        String[] tokens;
        String ruleStr = this.grammarRules.get(0).getRuleString();
        StringBuilder newRuleString = new StringBuilder();
        for (String t : tokens = ruleStr.split("\\s+")) {
            if (!t.startsWith("R")) continue;
            Integer rId = Integer.valueOf(t.substring(1));
            if (this.usedRules.contains(rId)) {
                newRuleString.append(t).append(" ");
                continue;
            }
            logger.debug("removed rule " + rId + " from R0");
        }
        if (newRuleString.length() > 0) {
            newRuleString.delete(newRuleString.length() - 1, newRuleString.length());
        }
        GrammarRuleRecord newR0 = new GrammarRuleRecord();
        newR0.setRuleNumber(0);
        newR0.setRuleString(newRuleString.toString());
        logger.trace(newR0.toString());
    }
}

