/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.sequitur;

import java.util.Hashtable;
import java.util.Map;
import net.seninp.gi.sequitur.SAXGuard;
import net.seninp.gi.sequitur.SAXNonTerminal;
import net.seninp.gi.sequitur.SAXRule;

public abstract class SAXSymbol {
    protected static final int numTerminals = 100000;
    private static final int prime = 2265539;
    protected static final Hashtable<SAXSymbol, SAXSymbol> theDigrams = new Hashtable(2265539);
    public static Hashtable<String, Hashtable<String, Integer>> theSubstituteTable = new Hashtable(2265539);
    protected String value;
    protected int originalPosition;
    public SAXSymbol p;
    public SAXSymbol n;

    public static void join(SAXSymbol left, SAXSymbol right) {
        if (left.n != null) {
            left.deleteDigram();
        }
        left.n = right;
        right.p = left;
    }

    public abstract void cleanUp();

    public void insertAfter(SAXSymbol toInsert) {
        SAXSymbol.join(toInsert, this.n);
        SAXSymbol.join(this, toInsert);
    }

    public void deleteDigram() {
        if (this.n.isGuard()) {
            return;
        }
        if (this == theDigrams.get(this)) {
            theDigrams.remove(this);
        }
    }

    public boolean isGuard() {
        return false;
    }

    public boolean isNonTerminal() {
        return false;
    }

    public boolean check() {
        if (this.n.isGuard()) {
            return false;
        }
        if (!theDigrams.containsKey(this)) {
            theDigrams.put(this, this);
            return false;
        }
        SAXSymbol found = theDigrams.get(this);
        if (found.n != this) {
            this.match(this, found);
        }
        return true;
    }

    public void substitute(SAXRule r) {
        r.addIndex(this.originalPosition);
        this.cleanUp();
        this.n.cleanUp();
        SAXNonTerminal nt = new SAXNonTerminal(r);
        nt.originalPosition = this.originalPosition;
        this.p.insertAfter(nt);
        if (!this.p.check()) {
            this.p.n.check();
        }
    }

    public void match(SAXSymbol theDigram, SAXSymbol matchingDigram) {
        SAXRule rule;
        if (matchingDigram.p.isGuard() && matchingDigram.n.n.isGuard()) {
            rule = ((SAXGuard)matchingDigram.p).r;
            theDigram.substitute(rule);
        } else {
            rule = new SAXRule();
            try {
                SAXSymbol first = (SAXSymbol)theDigram.clone();
                SAXSymbol second = (SAXSymbol)theDigram.n.clone();
                rule.theGuard.n = first;
                first.p = rule.theGuard;
                first.n = second;
                second.p = first;
                second.n = rule.theGuard;
                rule.theGuard.p = second;
                theDigrams.put(first, first);
                matchingDigram.substitute(rule);
                theDigram.substitute(rule);
            }
            catch (CloneNotSupportedException c) {
                c.printStackTrace();
            }
        }
        if (rule.first().isNonTerminal() && ((SAXNonTerminal)rule.first()).r.count == 1) {
            ((SAXNonTerminal)rule.first()).expand();
        }
        rule.assignLevel();
    }

    public int hashCode() {
        int hash1 = 31;
        int hash2 = 13;
        int num0 = 0;
        for (int i = 0; i < this.value.length(); ++i) {
            num0 += Character.getNumericValue(this.value.charAt(i));
        }
        int num1 = 0;
        for (int i = 0; i < this.n.value.length(); ++i) {
            num1 += Character.getNumericValue(this.n.value.charAt(i));
        }
        hash2 = num0 * hash1 + hash2 * num1;
        return hash2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAXSymbol)) {
            return false;
        }
        return this.value.equals(((SAXSymbol)obj).value) && this.n.value.equals(((SAXSymbol)obj).n.value);
    }

    public String toString() {
        return "SAXSymbol [value=" + this.value + ", p=" + this.p + ", n=" + this.n + "]";
    }

    protected static String getPayload(SAXSymbol symbol) {
        if (symbol.isGuard()) {
            return "guard of the rule " + ((SAXGuard)symbol).r.ruleIndex;
        }
        if (symbol.isNonTerminal()) {
            return "nonterminal " + ((SAXNonTerminal)symbol).value;
        }
        return "symbol " + symbol.value;
    }

    private static String makeDigramsTable() {
        StringBuffer sb = new StringBuffer("\n");
        for (Map.Entry<SAXSymbol, SAXSymbol> e : theDigrams.entrySet()) {
            sb.append("           ").append(SAXSymbol.getPayload(e.getKey())).append(", ").append(SAXSymbol.getPayload(e.getValue())).append("\n");
        }
        return sb.toString();
    }
}

