/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.gi.sequitur;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import net.seninp.gi.logic.GIUtils;
import net.seninp.gi.logic.GrammarRuleRecord;
import net.seninp.gi.logic.GrammarRules;
import net.seninp.gi.logic.RuleInterval;
import net.seninp.gi.sequitur.SAXRule;
import net.seninp.gi.sequitur.SAXSymbol;
import net.seninp.gi.sequitur.SAXTerminal;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import net.seninp.jmotif.sax.datastructure.SAXRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SequiturFactory {
    private static final NormalAlphabet normalA = new NormalAlphabet();
    private static SAXProcessor sp = new SAXProcessor();
    private static final Logger LOGGER = LoggerFactory.getLogger(SequiturFactory.class);

    private SequiturFactory() {
    }

    public static SAXRule runSequitur(String inputString) throws Exception {
        LOGGER.trace("digesting the string " + inputString);
        SAXRule.numRules = new AtomicInteger(0);
        SAXRule.theRules.clear();
        SAXSymbol.theDigrams.clear();
        SAXSymbol.theSubstituteTable.clear();
        SAXRule resRule = new SAXRule();
        StringTokenizer st = new StringTokenizer(inputString, " ");
        int currentPosition = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            SAXTerminal symbol = new SAXTerminal(token, currentPosition);
            resRule.last().insertAfter(symbol);
            resRule.last().p.check();
            ++currentPosition;
        }
        return resRule;
    }

    public static GrammarRules series2SequiturRules(double[] timeseries, int saxWindowSize, int saxPAASize, int saxAlphabetSize, NumerosityReductionStrategy numerosityReductionStrategy, double normalizationThreshold) throws Exception, IOException {
        LOGGER.debug("Discretizing time series...");
        SAXRecords saxFrequencyData = sp.ts2saxViaWindow(timeseries, saxWindowSize, saxPAASize, normalA.getCuts(Integer.valueOf(saxAlphabetSize)), numerosityReductionStrategy, normalizationThreshold);
        LOGGER.debug("Inferring the grammar...");
        String saxDisplayString = saxFrequencyData.getSAXString(" ");
        SAXRule.numRules = new AtomicInteger(0);
        SAXRule.theRules.clear();
        SAXSymbol.theDigrams.clear();
        SAXRule grammar = new SAXRule();
        SAXRule.arrRuleRecords = new ArrayList();
        StringTokenizer st = new StringTokenizer(saxDisplayString, " ");
        int currentPosition = 0;
        while (st.hasMoreTokens()) {
            grammar.last().insertAfter(new SAXTerminal(st.nextToken(), currentPosition));
            grammar.last().p.check();
            ++currentPosition;
        }
        LOGGER.debug("Collecting the grammar rules statistics and expanding the rules...");
        GrammarRules rules = grammar.toGrammarRulesData();
        LOGGER.debug("Mapping expanded rules to time-series intervals...");
        SequiturFactory.updateRuleIntervals(rules, saxFrequencyData, true, timeseries, saxWindowSize, saxPAASize);
        return rules;
    }

    public static void updateRuleIntervals(GrammarRules rules, SAXRecords saxFrequencyData, boolean slidingWindowOn, double[] originalTimeSeries, int saxWindowSize, int saxPAASize) {
        ArrayList saxWordsIndexes = new ArrayList(saxFrequencyData.getAllIndices());
        for (GrammarRuleRecord ruleContainer : rules) {
            ArrayList<RuleInterval> resultIntervals = new ArrayList<RuleInterval>();
            int expandedRuleLength = SequiturFactory.countSpaces(ruleContainer.getExpandedRuleString());
            int[] lengths = new int[ruleContainer.getOccurrences().size()];
            int lengthCounter = 0;
            for (Integer currentIndex : ruleContainer.getOccurrences()) {
                int startPos = (Integer)saxWordsIndexes.get(currentIndex);
                int endPos = -1;
                if (currentIndex + expandedRuleLength >= saxWordsIndexes.size()) {
                    endPos = originalTimeSeries.length;
                } else if (slidingWindowOn) {
                    endPos = (Integer)saxWordsIndexes.get(currentIndex + expandedRuleLength) + saxWindowSize - 1;
                } else {
                    double step = (double)originalTimeSeries.length / (double)saxPAASize;
                    endPos = Long.valueOf(Math.round((double)startPos + (double)expandedRuleLength * step)).intValue();
                }
                resultIntervals.add(new RuleInterval(startPos, endPos));
                lengths[lengthCounter] = endPos - startPos;
                ++lengthCounter;
            }
            if (0 == ruleContainer.getRuleNumber()) {
                resultIntervals.add(new RuleInterval(0, originalTimeSeries.length));
                lengths = new int[]{originalTimeSeries.length};
            }
            ruleContainer.setRuleIntervals(resultIntervals);
            ruleContainer.setMeanLength((int)GIUtils.mean(lengths));
            ruleContainer.setMinMaxLength(lengths);
        }
    }

    public static ArrayList<RuleInterval> getRulePositionsByRuleNum(int ruleIdx, SAXRule grammar, SAXRecords saxFrequencyData, double[] originalTimeSeries, int saxWindowSize) {
        ArrayList<RuleInterval> resultIntervals = new ArrayList<RuleInterval>();
        GrammarRuleRecord ruleContainer = grammar.getRuleRecords().get(ruleIdx);
        ArrayList saxWordsIndexes = new ArrayList(saxFrequencyData.getAllIndices());
        LOGGER.trace("Expanded rule: \"" + ruleContainer.getExpandedRuleString() + '\"');
        LOGGER.trace("Indexes: " + ruleContainer.getOccurrences());
        String[] expandedRuleSplit = ruleContainer.getExpandedRuleString().trim().split(" ");
        for (Integer currentIndex : ruleContainer.getOccurrences()) {
            String extractedStr = "";
            StringBuffer sb = new StringBuffer(expandedRuleSplit.length);
            for (int i = 0; i < expandedRuleSplit.length; ++i) {
                LOGGER.trace("currentIndex " + currentIndex + ", i: " + i);
                extractedStr = extractedStr.concat(" ").concat(String.valueOf(saxFrequencyData.getByIndex(((Integer)saxWordsIndexes.get(currentIndex + i)).intValue()).getPayload()));
                sb.append(saxWordsIndexes.get(currentIndex + i)).append(" ");
            }
            LOGGER.trace("Recovered string: " + extractedStr);
            LOGGER.trace("Recovered positions: " + sb.toString());
            int start = (Integer)saxWordsIndexes.get(currentIndex);
            int end = -1;
            end = currentIndex + expandedRuleSplit.length >= saxWordsIndexes.size() ? originalTimeSeries.length - 1 : (Integer)saxWordsIndexes.get(currentIndex + expandedRuleSplit.length) - 1 + saxWindowSize;
            resultIntervals.add(new RuleInterval(start, end));
        }
        return resultIntervals;
    }

    private static int countSpaces(String str) {
        int counter = 0;
        for (char c : str.toCharArray()) {
            if (c != ' ') continue;
            ++counter;
        }
        return counter;
    }
}

