/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actions;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import net.serenitybdd.screenplay.Action;
import net.serenitybdd.screenplay.actions.KeyNames;
import org.openqa.selenium.Keys;

public abstract class EnterValue
implements Action {
    protected final String theText;
    protected final List<Keys> followedByKeys;
    protected String followedBy;
    private final String ENTER_KEYS_INTRO_TEXT = " then hits ";

    public EnterValue(String theText) {
        this.theText = theText;
        this.followedByKeys = Lists.newArrayList();
    }

    public EnterValue thenHit(Keys ... keys) {
        this.followedByKeys.addAll(Lists.newArrayList((Object[])keys));
        this.followedBy = this.getFollowedByKeysDescriptionFor(this.followedByKeys);
        return this;
    }

    public Keys[] getFollowedByKeys() {
        return this.followedByKeys.toArray(new Keys[0]);
    }

    private String getFollowedByKeysDescriptionFor(List<Keys> keys) {
        if (keys.isEmpty()) {
            return "";
        }
        if (keys.size() == 1) {
            return " then hits " + KeyNames.of(keys);
        }
        if (keys.size() == 2) {
            return " then hits " + Joiner.on((String)" and ").join(KeyNames.of(keys));
        }
        String allButLastTwo = Joiner.on((String)", ").join(KeyNames.allButLastTwo(keys));
        String lastTwoKeys = Joiner.on((String)" and ").join(KeyNames.lastTwoOf(keys));
        String allKeys = Joiner.on((String)", ").join((Iterable)ImmutableList.of((Object)allButLastTwo, (Object)lastTwoKeys));
        return " then hits " + allKeys;
    }
}

