/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.stacktrace;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;

public class StackTraceSanitizer {
    private final EnvironmentVariables environmentVariables;
    private final StackTraceElement[] stackTrace;
    private static final List<String> MASKED_PACKAGES = ImmutableList.of((Object)"sun.", (Object)"com.sun", (Object)"java.", (Object)"org.junit", (Object)"org.gradle", (Object)"org.testng", (Object)"org.hamcrest", (Object)"org.fest", (Object)"org.assertj", (Object)"org.openqa.selenium", (Object)"org.spockframework", (Object)"org.apache.maven.surefire", (Object[])new String[]{"com.intellij", "net.sf.cglib", "org.codehaus.groovy", "org.jbehave", "cucumber.runtime", "net.serenitybdd", "net.thucydides"});

    public StackTraceSanitizer(EnvironmentVariables environmentVariables, StackTraceElement[] stackTrace) {
        this.environmentVariables = environmentVariables;
        this.stackTrace = stackTrace;
    }

    public static StackTraceSanitizer forStackTrace(StackTraceElement[] stackTrace) {
        return new StackTraceSanitizer((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get(), stackTrace);
    }

    public StackTraceElement[] sanitized(StackTraceElement[] stackTrace) {
        return this.useSimplifedStackTraces() ? this.simplifiedStackTrace(stackTrace) : stackTrace;
    }

    private boolean useSimplifedStackTraces() {
        return ThucydidesSystemProperty.SIMPLIFIED_STACK_TRACES.booleanFrom(this.environmentVariables, true);
    }

    private StackTraceElement[] simplifiedStackTrace(StackTraceElement[] stackTrace) {
        ArrayList cleanStackTrace = Lists.newArrayList();
        for (StackTraceElement element : stackTrace) {
            if (!this.shouldDisplayInStackTrace(element)) continue;
            cleanStackTrace.add(element);
        }
        return cleanStackTrace.toArray(new StackTraceElement[0]);
    }

    private boolean shouldDisplayInStackTrace(StackTraceElement element) {
        if (element.getClassName().contains("$")) {
            return false;
        }
        for (String maskedPackage : MASKED_PACKAGES) {
            if (!element.getClassName().startsWith(maskedPackage)) continue;
            return false;
        }
        return true;
    }

    public StackTraceElement[] getSanitizedStackTrace() {
        return this.sanitized(this.stackTrace);
    }
}

