/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections.IteratorUtils;

public class ExampleTable {
    private static final String SQUARE_BRACKETS_OR_WHITE_SPACE = "[]\uff3b\uff3d \t";
    List<String> headers;
    List<List<String>> rows = Lists.newArrayList();
    static final Pattern NEW_LINE = Pattern.compile("(\\r\\n)|(\\n)|(\\r)|(\u2424)|(\\r\u2424)");

    public ExampleTable(String tableContents) {
        List lines = IteratorUtils.toList(Splitter.on((Pattern)NEW_LINE).omitEmptyStrings().trimResults(CharMatcher.anyOf((CharSequence)SQUARE_BRACKETS_OR_WHITE_SPACE)).split((CharSequence)tableContents).iterator());
        this.addHeaderFrom((String)lines.get(0));
        for (int row = 1; row < lines.size(); ++row) {
            this.addRowFrom((String)lines.get(row));
        }
    }

    private void addRowFrom(String row) {
        this.rows.add(this.cellsFrom(row));
    }

    private void addHeaderFrom(String headerLine) {
        this.headers = this.cellsFrom(headerLine);
    }

    private List<String> cellsFrom(String line) {
        if ((line = line.trim()).startsWith("|")) {
            line = line.substring(1);
        }
        if (line.endsWith("|")) {
            line = line.substring(0, line.length() - 1);
        }
        return IteratorUtils.toList(Splitter.on((String)"|").trimResults().split((CharSequence)line).iterator());
    }

    public String inHtmlFormat() {
        return "<table class='embedded'>" + this.getHtmlHeader() + this.getHtmlBody() + "</table>";
    }

    public String getHtmlHeader() {
        StringBuffer htmlHeader = new StringBuffer();
        htmlHeader.append("<thead>");
        for (String header : this.headers) {
            htmlHeader.append("<th>").append(header).append("</th>");
        }
        htmlHeader.append("</thead>");
        return htmlHeader.toString();
    }

    public String getHtmlBody() {
        StringBuffer htmlBody = new StringBuffer();
        htmlBody.append("<tbody>");
        for (List<String> row : this.rows) {
            htmlBody.append("<tr>");
            for (String cell : row) {
                htmlBody.append("<td>").append(cell).append("</td>");
            }
            htmlBody.append("</tr>");
        }
        htmlBody.append("</tbody>");
        return htmlBody.toString();
    }
}

