/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.beust.jcommander.internal.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.SerenitySystemProperties;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.NumericalFormatter;
import net.thucydides.core.model.Release;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.releases.ReleaseManager;
import net.thucydides.core.reports.FormatConfiguration;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.ReportOptions;
import net.thucydides.core.reports.TestOutcomeLoader;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.UserStoryTestReporter;
import net.thucydides.core.reports.csv.CSVReporter;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.html.HtmlRequirementsReporter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportProperties;
import net.thucydides.core.reports.html.TagFilter;
import net.thucydides.core.requirements.RequirementsProviderService;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.model.RequirementsConfiguration;
import net.thucydides.core.requirements.reports.RequirementOutcome;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.requirements.reports.RequirmentsOutcomeFactory;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.util.VersionProvider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlAggregateStoryReporter
extends HtmlReporter
implements UserStoryTestReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlAggregateStoryReporter.class);
    private static final String HISTORY_TEMPLATE_PATH = "freemarker/history.ftl";
    private static final String TEST_OUTCOME_TEMPLATE_PATH = "freemarker/home.ftl";
    private static final String RELEASES_TEMPLATE_PATH = "freemarker/releases.ftl";
    private static final String RELEASE_TEMPLATE_PATH = "freemarker/release.ftl";
    private static final String TAGTYPE_TEMPLATE_PATH = "freemarker/results-by-tagtype.ftl";
    private static final String REQUIREMENT_TYPE_TEMPLATE_PATH = "freemarker/requirement-type.ftl";
    private String projectName;
    private String relativeLink;
    private ReportNameProvider reportNameProvider;
    private final IssueTracking issueTracking;
    private final RequirementsService requirementsService;
    private final RequirmentsOutcomeFactory requirementsFactory;
    private final HtmlRequirementsReporter htmlRequirementsReporter;
    private final RequirementsConfiguration requirementsConfiguration;
    private final EnvironmentVariables environmentVariables;
    private FormatConfiguration formatConfiguration;
    List<Requirement> reportTally = Lists.newArrayList();
    private ReleaseManager releaseManager;
    private ReportNameProvider defaultNameProvider;

    public HtmlAggregateStoryReporter(String projectName) {
        this(projectName, "");
    }

    public HtmlAggregateStoryReporter(String projectName, String relativeLink) {
        this(projectName, relativeLink, (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class), (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public HtmlAggregateStoryReporter(String projectName, IssueTracking issueTracking) {
        this(projectName, "", issueTracking, (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public HtmlAggregateStoryReporter(String projectName, String relativeLink, IssueTracking issueTracking, RequirementsService requirementsService, EnvironmentVariables environmentVariables) {
        this.projectName = projectName;
        this.relativeLink = relativeLink;
        this.issueTracking = issueTracking;
        this.reportNameProvider = new ReportNameProvider();
        this.htmlRequirementsReporter = new HtmlRequirementsReporter(relativeLink);
        RequirementsProviderService requirementsProviderService = (RequirementsProviderService)Injectors.getInjector().getInstance(RequirementsProviderService.class);
        this.requirementsFactory = new RequirmentsOutcomeFactory(requirementsProviderService.getRequirementsProviders(), issueTracking);
        this.requirementsService = requirementsService;
        this.requirementsConfiguration = new RequirementsConfiguration(this.getEnvironmentVariables());
        this.environmentVariables = environmentVariables;
        this.formatConfiguration = new FormatConfiguration(environmentVariables);
    }

    public OutcomeFormat getFormat() {
        return this.formatConfiguration.getPreferredFormat();
    }

    public String getProjectName() {
        return this.projectName;
    }

    private void addFormattersToContext(Map<String, Object> context) {
        Formatter formatter = new Formatter(this.issueTracking);
        context.put("formatter", formatter);
        context.put("formatted", new NumericalFormatter());
        context.put("inflection", Inflector.getInstance());
        context.put("relativeLink", this.relativeLink);
        context.put("reportOptions", new ReportOptions(this.getEnvironmentVariables()));
    }

    @Override
    public TestOutcomes generateReportsForTestResultsFrom(File sourceDirectory) throws IOException {
        TestOutcomes allTestOutcomes = this.loadTestOutcomesFrom(sourceDirectory);
        this.copyScreenshotsFrom(sourceDirectory);
        this.generateReportsForTestResultsIn(allTestOutcomes);
        return allTestOutcomes;
    }

    private void copyScreenshotsFrom(File sourceDirectory) {
        if (this.getOutputDirectory() != null && this.getOutputDirectory() != sourceDirectory) {
            CopyOption[] options = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
            Path targetPath = Paths.get(this.getOutputDirectory().toURI());
            Path sourcePath = Paths.get(sourceDirectory.toURI());
            try {
                DirectoryStream<Path> directoryContents = Files.newDirectoryStream(sourcePath);
                for (Path sourceFile : directoryContents) {
                    Path destinationFile = targetPath.resolve(sourceFile.getFileName());
                    if (!Files.notExists(destinationFile, new LinkOption[0])) continue;
                    Files.copy(sourceFile, destinationFile, options);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error during copying files to the target directory", (Throwable)e);
            }
        }
    }

    public void generateReportsForTestResultsIn(TestOutcomes testOutcomes) throws IOException {
        RequirementsOutcomes requirementsOutcomes = this.requirementsFactory.buildRequirementsOutcomesFrom(testOutcomes.withRequirementsTags());
        this.copyResourcesToOutputDirectory();
        this.copyTestResultsToOutputDirectory();
        this.generateAggregateReportFor(testOutcomes);
        this.generateTagReportsFor(testOutcomes);
        this.generateTagTypeReportsFor(testOutcomes);
        for (String name : testOutcomes.getTagNames()) {
            this.generateTagTypeReportsFor(testOutcomes.withTag(name), new ReportNameProvider(name));
        }
        this.generateRequirementTypeReports(requirementsOutcomes);
        this.generateResultReportsFor(testOutcomes);
        this.generateRequirementsReportsFor(requirementsOutcomes);
        this.generateReleasesReportFor(testOutcomes, requirementsOutcomes);
    }

    private void generateRequirementTypeReports(RequirementsOutcomes requirementsOutcomes) throws IOException {
        List<String> requirementTypes = requirementsOutcomes.getTypes();
        for (String requirementType : requirementTypes) {
            this.generateRequirementTypeReportFor(requirementType, requirementsOutcomes.requirementsOfType(requirementType), new ReportNameProvider());
        }
    }

    private void generateRequirementTypeReportFor(String requirementType, RequirementsOutcomes requirementsOutcomes, ReportNameProvider reporter) throws IOException {
        Map<String, Object> context = this.buildContext(requirementsOutcomes.getTestOutcomes(), this.getReportNameProvider());
        context.put("report", ReportProperties.forAggregateResultsReport());
        context.put("requirementType", requirementType);
        context.put("requirements", requirementsOutcomes);
        String reportName = reporter.forRequirementType(requirementType);
        this.generateReportPage(context, REQUIREMENT_TYPE_TEMPLATE_PATH, reportName);
    }

    private void generateCSVReportFor(TestOutcomes testOutcomes, String reportName) throws IOException {
        CSVReporter csvReporter = new CSVReporter(this.getOutputDirectory(), this.getEnvironmentVariables());
        csvReporter.generateReportFor(testOutcomes, reportName);
    }

    public void generateRequirementsReportsFor(RequirementsOutcomes requirementsOutcomes) throws IOException {
        this.htmlRequirementsReporter.setOutputDirectory(this.getOutputDirectory());
        this.htmlRequirementsReporter.generateReportFor(requirementsOutcomes);
        this.clearReportTally();
        this.generateRequirementsReportsForChildRequirements(requirementsOutcomes);
    }

    private void clearReportTally() {
        this.reportTally.clear();
    }

    private void generateRequirementsReportsForChildRequirements(RequirementsOutcomes requirementsOutcomes) throws IOException {
        List<RequirementOutcome> requirementOutcomes = requirementsOutcomes.getRequirementOutcomes();
        for (RequirementOutcome outcome : requirementOutcomes) {
            Requirement requirement = outcome.getRequirement();
            if (this.reportTally.contains(requirement)) continue;
            TestOutcomes testOutcomesForThisRequirement = outcome.getTestOutcomes().withTag(requirement.asTag());
            RequirementsOutcomes requirementOutcomesForThisRequirement = this.requirementsFactory.buildRequirementsOutcomesFrom(requirement, testOutcomesForThisRequirement);
            this.generateNestedRequirementsReportsFor(requirement, requirementOutcomesForThisRequirement);
        }
    }

    private void generateNestedRequirementsReportsFor(Requirement parentRequirement, RequirementsOutcomes requirementsOutcomes) throws IOException {
        this.htmlRequirementsReporter.setOutputDirectory(this.getOutputDirectory());
        String reportName = this.reportNameProvider.forRequirement(parentRequirement);
        if (!this.reportTally.contains(parentRequirement)) {
            this.reportTally.add(parentRequirement);
            this.htmlRequirementsReporter.generateReportFor(requirementsOutcomes, requirementsOutcomes.getTestOutcomes(), reportName);
        }
        this.generateRequirementsReportsForChildRequirements(requirementsOutcomes);
    }

    private TestOutcomes loadTestOutcomesFrom(File sourceDirectory) throws IOException {
        return TestOutcomeLoader.loadTestOutcomes().inFormat(this.getFormat()).from(sourceDirectory).withHistory().withRequirementsTags();
    }

    private void generateAggregateReportFor(TestOutcomes testOutcomes) throws IOException {
        ReportNameProvider defaultNameProvider = new ReportNameProvider();
        Map<String, Object> context = this.buildContext(testOutcomes, defaultNameProvider, true);
        context.put("report", ReportProperties.forAggregateResultsReport());
        context.put("csvReport", "results.csv");
        this.generateReportPage(context, TEST_OUTCOME_TEMPLATE_PATH, "index.html");
        this.generateCSVReportFor(testOutcomes, "results.csv");
        this.logReportPathMessage();
    }

    private void logReportPathMessage() {
        LOGGER.info("REPORTS GENERATED IN " + this.getOutputDirectory().getAbsolutePath());
        LOGGER.info("REPORT HOME PAGE: " + this.getOutputDirectory().getAbsolutePath() + File.separator + "index.html");
    }

    private ReleaseManager getReleaseManager() {
        if (this.releaseManager == null) {
            ReportNameProvider defaultNameProvider = new ReportNameProvider();
            this.releaseManager = new ReleaseManager(this.getEnvironmentVariables(), defaultNameProvider);
        }
        return this.releaseManager;
    }

    private ReportNameProvider getReportNameProvider() {
        if (this.defaultNameProvider == null) {
            this.defaultNameProvider = new ReportNameProvider();
        }
        return this.defaultNameProvider;
    }

    private void generateReleasesReportFor(TestOutcomes testOutcomes, RequirementsOutcomes requirementsOutcomes) throws IOException {
        Map<String, Object> context = this.buildContext(testOutcomes, this.getReportNameProvider());
        context.put("report", ReportProperties.forAggregateResultsReport());
        List<Release> releases = this.getReleaseManager().getReleasesFrom(testOutcomes);
        LOGGER.info("Generating release reports for: " + releases);
        if (!releases.isEmpty()) {
            String releaseData = this.getReleaseManager().getJSONReleasesFrom(testOutcomes);
            context.put("releases", releases);
            context.put("releaseData", releaseData);
            context.put("requirements", requirementsOutcomes);
            this.generateReportPage(context, RELEASES_TEMPLATE_PATH, "releases.html");
            this.generateReleaseDetailsReportsFor(testOutcomes, requirementsOutcomes);
        }
    }

    private void generateReleaseDetailsReportsFor(TestOutcomes testOutcomes, RequirementsOutcomes requirementsOutcomes) throws IOException {
        List<Release> allReleases = this.getReleaseManager().getFlattenedReleasesFrom(testOutcomes);
        List<String> requirementsTypes = this.getRequirementTypes();
        String topLevelRequirementType = requirementsTypes.get(0);
        String secondLevelRequirementType = "";
        String secondLevelRequirementTypeTitle = "";
        String topLevelRequirementTypeTitle = Inflector.getInstance().of(topLevelRequirementType).inPluralForm().asATitle().toString();
        if (requirementsTypes.size() > 1) {
            secondLevelRequirementType = requirementsTypes.get(1);
            secondLevelRequirementTypeTitle = Inflector.getInstance().of(secondLevelRequirementType).inPluralForm().asATitle().toString();
        }
        for (Release release : allReleases) {
            RequirementsOutcomes releaseRequirements = requirementsOutcomes.getReleasedRequirementsFor(release);
            Map<String, Object> context = this.buildContext(testOutcomes, this.getReportNameProvider());
            context.put("report", ReportProperties.forAggregateResultsReport());
            context.put("release", release);
            context.put("releaseData", this.getReleaseManager().getJSONReleasesFrom(release));
            context.put("releaseRequirementOutcomes", releaseRequirements.getRequirementOutcomes());
            context.put("releaseTestOutcomes", testOutcomes.withTag(release.getReleaseTag()));
            context.put("requirementType", topLevelRequirementTypeTitle);
            if (StringUtils.isNotBlank((CharSequence)secondLevelRequirementTypeTitle)) {
                context.put("secondLevelRequirementType", secondLevelRequirementTypeTitle);
            }
            String reportName = this.getReportNameProvider().forRelease(release);
            this.generateReportPage(context, RELEASE_TEMPLATE_PATH, reportName);
        }
    }

    private void generateTagReportsFor(TestOutcomes testOutcomes) throws IOException {
        for (TestTag tag : testOutcomes.getTags()) {
            this.generateTagReport(testOutcomes, this.reportNameProvider, tag);
            this.generateAssociatedTagReportsForTag(testOutcomes.withTag(tag), tag.getName());
        }
    }

    private void generateTagTypeReportsFor(TestOutcomes testOutcomes) throws IOException {
        this.generateTagTypeReportsFor(testOutcomes, this.reportNameProvider);
    }

    private void generateTagTypeReportsFor(TestOutcomes testOutcomes, ReportNameProvider reportNameProvider) throws IOException {
        for (String tagType : testOutcomes.getTagTypes()) {
            this.generateTagTypeReport(testOutcomes, reportNameProvider, tagType);
        }
    }

    private void generateResultReportsFor(TestOutcomes testOutcomes) throws IOException {
        this.generateResultReports(testOutcomes, this.reportNameProvider);
        for (TestTag tag : testOutcomes.getTags()) {
            this.generateResultReports(testOutcomes.withTag(tag), new ReportNameProvider(tag.getName()), tag);
        }
    }

    private void generateResultReports(TestOutcomes testOutcomes, ReportNameProvider reportName) throws IOException {
        this.generateResultReports(testOutcomes, reportName, TestTag.EMPTY_TAG);
    }

    private void generateResultReports(TestOutcomes testOutcomesForThisTag, ReportNameProvider reportName, TestTag tag) throws IOException {
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.SUCCESS) > 0) {
            this.generateResultReport(testOutcomesForThisTag.getPassingTests(), reportName, tag, "success");
        }
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.PENDING) > 0) {
            this.generateResultReport(testOutcomesForThisTag.getPendingTests(), reportName, tag, "pending");
        }
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.FAILURE) > 0) {
            this.generateResultReport(testOutcomesForThisTag.getFailingTests(), reportName, tag, "failure");
        }
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.ERROR) > 0) {
            this.generateResultReport(testOutcomesForThisTag.getErrorTests(), reportName, tag, "error");
        }
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.IGNORED) > 0) {
            this.generateResultReport(testOutcomesForThisTag.havingResult(TestResult.IGNORED), reportName, tag, "ignored");
        }
        if (testOutcomesForThisTag.getTotalTests().withResult(TestResult.SKIPPED) > 0) {
            this.generateResultReport(testOutcomesForThisTag.havingResult(TestResult.SKIPPED), reportName, tag, "skipped");
        }
    }

    private void generateResultReport(TestOutcomes testOutcomes, ReportNameProvider reportName, TestTag tag, String testResult) throws IOException {
        Map<String, Object> context = this.buildContext(testOutcomes, reportName);
        context.put("report", ReportProperties.forTestResultsReport());
        context.put("currentTagType", tag.getType());
        context.put("currentTag", tag);
        String csvReport = reportName.forCSVFiles().forTestResult(testResult);
        context.put("csvReport", csvReport);
        String report = reportName.withPrefix(tag).forTestResult(testResult);
        this.generateReportPage(context, TEST_OUTCOME_TEMPLATE_PATH, report);
        this.generateCSVReportFor(testOutcomes, csvReport);
    }

    private void generateTagReport(TestOutcomes testOutcomes, ReportNameProvider reportName, TestTag tag) throws IOException {
        TestOutcomes testOutcomesForTag = testOutcomes.withTag(tag);
        Map<String, Object> context = this.buildContext(testOutcomesForTag, reportName);
        context.put("report", ReportProperties.forTagResultsReport());
        context.put("currentTagType", tag.getType());
        context.put("currentTag", tag);
        String csvReport = reportName.forCSVFiles().forTag(tag);
        context.put("csvReport", csvReport);
        String report = reportName.forTag(tag);
        this.generateReportPage(context, TEST_OUTCOME_TEMPLATE_PATH, report);
        this.generateCSVReportFor(testOutcomesForTag, csvReport);
    }

    private void generateTagTypeReport(TestOutcomes testOutcomes, ReportNameProvider reportName, String tagType) throws IOException {
        TestOutcomes testOutcomesForTagType = testOutcomes.withTagType(tagType);
        Map<String, Object> context = this.buildContext(testOutcomesForTagType, reportName);
        context.put("report", ReportProperties.forTagTypeResultsReport());
        context.put("tagType", tagType);
        String csvReport = reportName.forCSVFiles().forTagType(tagType);
        context.put("csvReport", csvReport);
        String report = reportName.forTagType(tagType);
        this.generateReportPage(context, TAGTYPE_TEMPLATE_PATH, report);
        this.generateCSVReportFor(testOutcomesForTagType, csvReport);
    }

    private void generateAssociatedTagReportsForTag(TestOutcomes testOutcomes, String sourceTag) throws IOException {
        ReportNameProvider reportName = new ReportNameProvider(sourceTag);
        for (TestTag tag : testOutcomes.getTags()) {
            this.generateTagReport(testOutcomes, reportName, tag);
        }
    }

    private Map<String, Object> buildContext(TestOutcomes testOutcomesForTagType, ReportNameProvider reportName) {
        return this.buildContext(testOutcomesForTagType, reportName, false);
    }

    private Map<String, Object> buildContext(TestOutcomes testOutcomesForTagType, ReportNameProvider reportName, boolean useFiltering) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        TagFilter tagFilter = new TagFilter(this.getEnvironmentVariables());
        context.put("testOutcomes", testOutcomesForTagType);
        context.put("allTestOutcomes", testOutcomesForTagType.getRootOutcomes());
        if (useFiltering) {
            context.put("tagTypes", tagFilter.filteredTagTypes(testOutcomesForTagType.getTagTypes()));
        } else {
            context.put("tagTypes", testOutcomesForTagType.getTagTypes());
        }
        context.put("currentTag", TestTag.EMPTY_TAG);
        context.put("reportName", reportName);
        context.put("absoluteReportName", new ReportNameProvider());
        context.put("reportOptions", new ReportOptions(this.getEnvironmentVariables()));
        context.put("timestamp", this.timestampFrom(this.currentTime()));
        context.put("requirementTypes", this.requirementsService.getRequirementTypes());
        this.addFormattersToContext(context);
        VersionProvider versionProvider = new VersionProvider(this.environmentVariables);
        context.put("serenityVersionNumber", versionProvider.getVersion());
        context.put("buildNumber", versionProvider.getBuildNumberText());
        return context;
    }

    private void generateReportPage(Map<String, Object> context, String template, String outputFile) throws IOException {
        String htmlContents = this.mergeTemplate(template).usingContext(context);
        this.writeReportToOutputDirectory(outputFile, htmlContents);
    }

    protected SerenitySystemProperties getSystemProperties() {
        return SerenitySystemProperties.getProperties();
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        if (issueTrackerUrl != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.THUCYDIDES_ISSUE_TRACKER_URL, issueTrackerUrl);
        }
    }

    public void setJiraUrl(String jiraUrl) {
        if (jiraUrl != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_URL, jiraUrl);
        }
    }

    public void setJiraProject(String jiraProject) {
        if (jiraProject != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_PROJECT, jiraProject);
        }
    }

    public void setJiraUsername(String jiraUsername) {
        if (jiraUsername != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_USERNAME, jiraUsername);
        }
    }

    public void setJiraPassword(String jiraPassword) {
        if (jiraPassword != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_PASSWORD, jiraPassword);
        }
    }

    public List<String> getRequirementTypes() {
        List<String> types = this.requirementsService.getRequirementTypes();
        if (types.isEmpty()) {
            LOGGER.warn("No requirement types found in the test outcome requirements: using default requirements");
            return this.requirementsConfiguration.getRequirementTypes();
        }
        return types;
    }
}

