/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.requirements.SearchForFilesOfType;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class RequirementsConfiguration {
    public static final List<String> DEFAULT_CAPABILITY_TYPES = ImmutableList.of((Object)"capability", (Object)"feature", (Object)"story");
    protected static final String DEFAULT_ROOT_DIRECTORY = "stories";
    private EnvironmentVariables environmentVariables;
    private String rootRequirementsDirectory = "/";
    SearchForFilesOfType jbehaveFileMatcher;
    SearchForFilesOfType cucumberFileMatcher;

    public RequirementsConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public List<String> getRequirementTypes() {
        ArrayList types;
        String requirementTypes = ThucydidesSystemProperty.THUCYDIDES_REQUIREMENT_TYPES.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)requirementTypes)) {
            Iterator typeValues = Splitter.on((String)",").trimResults().split((CharSequence)requirementTypes).iterator();
            types = Lists.newArrayList(typeValues);
        } else {
            types = this.getDefaultCapabilityTypes();
        }
        return types;
    }

    public String getDefaultRootDirectory() {
        if (ThucydidesSystemProperty.THUCYDIDES_ANNOTATED_REQUIREMENTS_DIR.isDefinedIn(this.environmentVariables)) {
            return ThucydidesSystemProperty.THUCYDIDES_ANNOTATED_REQUIREMENTS_DIR.from(this.environmentVariables);
        }
        return DEFAULT_ROOT_DIRECTORY;
    }

    public List<String> getDefaultCapabilityTypes() {
        if (this.jbehaveFilesExist()) {
            return this.jbehaveCapabilityTypes();
        }
        if (this.cucumberFilesExist()) {
            return this.cucumberCapabilityTypes();
        }
        return DEFAULT_CAPABILITY_TYPES;
    }

    private List<String> jbehaveCapabilityTypes() {
        int featureDirectoryDepth = ((SearchForFilesOfType)this.getJBehaveFileMatcher().get()).getMaxDepth();
        switch (featureDirectoryDepth) {
            case 0: {
                return ImmutableList.of((Object)"story");
            }
            case 1: {
                return ImmutableList.of((Object)"feature", (Object)"story");
            }
        }
        return ImmutableList.of((Object)"capability", (Object)"feature", (Object)"story");
    }

    private List<String> cucumberCapabilityTypes() {
        int featureDirectoryDepth = ((SearchForFilesOfType)this.getCucumberFileMatcher().get()).getMaxDepth();
        switch (featureDirectoryDepth) {
            case 0: {
                return ImmutableList.of((Object)"feature");
            }
            case 1: {
                return ImmutableList.of((Object)"capability", (Object)"feature");
            }
        }
        return ImmutableList.of((Object)"theme", (Object)"capability", (Object)"feature");
    }

    private Optional<SearchForFilesOfType> getJBehaveFileMatcher() {
        if (this.jbehaveFileMatcher != null) {
            return Optional.of((Object)this.jbehaveFileMatcher);
        }
        try {
            Path root = this.findResourcePath(this.rootRequirementsDirectory + "/stories");
            if (root != null) {
                this.jbehaveFileMatcher = new SearchForFilesOfType(root, ".story");
                Files.walkFileTree(root, this.jbehaveFileMatcher);
                return Optional.of((Object)this.jbehaveFileMatcher);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return Optional.absent();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.absent();
        }
        return Optional.absent();
    }

    private Path findResourcePath(String path) throws URISyntaxException {
        URL storyDirectory = this.getClass().getResource(path);
        Path root = storyDirectory != null ? Paths.get(storyDirectory.toURI()) : Paths.get("src/test/resources/" + path, new String[0]);
        return root;
    }

    private Optional<SearchForFilesOfType> getCucumberFileMatcher() {
        if (this.cucumberFileMatcher != null) {
            return Optional.of((Object)this.cucumberFileMatcher);
        }
        try {
            Path root = this.findResourcePath(this.rootRequirementsDirectory + "/features");
            if (root != null) {
                this.cucumberFileMatcher = new SearchForFilesOfType(root, ".feature");
                Files.walkFileTree(root, this.cucumberFileMatcher);
                return Optional.of((Object)this.cucumberFileMatcher);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return Optional.absent();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.absent();
        }
        return Optional.absent();
    }

    private boolean jbehaveFilesExist() {
        return this.getJBehaveFileMatcher().isPresent() && ((SearchForFilesOfType)this.getJBehaveFileMatcher().get()).hasMatchingFiles();
    }

    private boolean cucumberFilesExist() {
        return this.getCucumberFileMatcher().isPresent() && ((SearchForFilesOfType)this.getCucumberFileMatcher().get()).hasMatchingFiles();
    }
}

