/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import ch.lambdaj.function.convert.DefaultStringConverter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.PropertiesFileLocalPreferences;
import net.thucydides.core.util.PropertiesUtil;
import org.apache.commons.lang3.StringUtils;

public class SystemEnvironmentVariables
implements EnvironmentVariables {
    private Properties systemProperties;
    private Map<String, String> systemValues;

    public SystemEnvironmentVariables() {
        this(System.getProperties(), System.getenv());
    }

    protected SystemEnvironmentVariables(Properties systemProperties, Map<String, String> systemValues) {
        this.systemProperties = PropertiesUtil.copyOf(systemProperties);
        this.systemValues = new HashMap<String, String>(systemValues);
    }

    @Override
    public String getValue(String name) {
        return this.getValue(name, null);
    }

    @Override
    public String getValue(Enum<?> property) {
        return this.getValue(property.toString());
    }

    @Override
    public String getValue(String name, String defaultValue) {
        String value = this.systemValues.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public String getValue(Enum<?> property, String defaultValue) {
        return this.getValue(property.toString(), defaultValue);
    }

    @Override
    public List<String> getKeys() {
        return Lambda.convert(this.systemProperties.keySet(), (Converter)new DefaultStringConverter());
    }

    @Override
    public Properties getProperties() {
        return new Properties(this.systemProperties);
    }

    @Override
    public Integer getPropertyAsInteger(String property, Integer defaultValue) {
        String value = (String)this.systemProperties.get(property);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    @Override
    public Integer getPropertyAsInteger(Enum<?> property, Integer defaultValue) {
        return this.getPropertyAsInteger(property.toString(), defaultValue);
    }

    @Override
    public Boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        if (this.getProperty(name) == null) {
            return defaultValue;
        }
        if (StringUtils.isBlank((CharSequence)this.getProperty(name))) {
            return true;
        }
        return Boolean.parseBoolean(this.getProperty(name, "false"));
    }

    @Override
    public Boolean getPropertyAsBoolean(Enum<?> property, boolean defaultValue) {
        return this.getPropertyAsBoolean(property.toString(), defaultValue);
    }

    @Override
    public String getProperty(String name) {
        return (String)this.systemProperties.get(name);
    }

    @Override
    public String getProperty(Enum<?> property) {
        return this.getProperty(property.toString());
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return this.systemProperties.getProperty(name, defaultValue);
    }

    @Override
    public String getProperty(Enum<?> property, String defaultValue) {
        return this.getProperty(property.toString(), defaultValue);
    }

    @Override
    public void setProperty(String name, String value) {
        this.systemProperties.setProperty(name, value);
    }

    @Override
    public void clearProperty(String name) {
        this.systemProperties.remove(name);
    }

    @Override
    public EnvironmentVariables copy() {
        return new SystemEnvironmentVariables(this.systemProperties, this.systemValues);
    }

    public static EnvironmentVariables createEnvironmentVariables() {
        SystemEnvironmentVariables environmentVariables = new SystemEnvironmentVariables();
        PropertiesFileLocalPreferences localPreferences = new PropertiesFileLocalPreferences(environmentVariables);
        try {
            localPreferences.loadPreferences();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return environmentVariables;
    }
}

