/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.maven.plugins;

import net.serenitybdd.maven.plugins.UpdatedClassLoader;
import net.thucydides.core.requirements.model.cucumber.FeatureFileChecker;
import net.thucydides.core.requirements.model.cucumber.FeatureFileFinder;
import net.thucydides.core.requirements.model.cucumber.InvalidFeatureFileException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="check-gherkin", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class SerenityGherkinCheckerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}")
    protected MavenSession session;
    @Parameter(defaultValue="src/test/resources/features")
    protected String featureFilesDirectory;
    @Parameter(defaultValue="${project}")
    public MavenProject project;
    FeatureFileChecker checker = new FeatureFileChecker();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Checking Feature Files");
        UpdatedClassLoader.withProjectClassesFrom(this.project);
        FeatureFileFinder finder = new FeatureFileFinder(this.featureFilesDirectory);
        try {
            this.checker.check(finder.findFeatureFiles());
        }
        catch (InvalidFeatureFileException e) {
            throw new MojoFailureException(e.getMessage());
        }
        catch (Throwable e) {
            this.getLog().error(e);
            throw new MojoFailureException(e.getMessage());
        }
    }
}

