/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.browserstack;

import net.serenitybdd.browserstack.BrowserStackTestSession;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.webdriver.RemoteDriver;
import net.serenitybdd.core.webdriver.enhancers.AfterAWebdriverScenario;
import net.thucydides.core.model.ExternalLink;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfterABrowserStackScenario
implements AfterAWebdriverScenario {
    private static final Logger LOGGER = LoggerFactory.getLogger(AfterABrowserStackScenario.class);

    public void apply(EnvironmentVariables environmentVariables, TestOutcome testOutcome, WebDriver driver) {
        if (driver == null || !RemoteDriver.isARemoteDriver((WebDriver)driver)) {
            return;
        }
        String sessionId = RemoteDriver.of((WebDriver)driver).getSessionId().toString();
        String userName = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{"browserstack.user"}).orElse(null);
        String key = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{"browserstack.key"}).orElse(null);
        BrowserStackTestSession browserStackTestSession = new BrowserStackTestSession(userName, key, sessionId);
        browserStackTestSession.updateTestResultFor(testOutcome);
        String publicUrl = browserStackTestSession.getPublicUrl();
        testOutcome.setLink(new ExternalLink(publicUrl, "BrowserStack"));
    }
}

