/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.browserstack;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import org.apache.commons.codec.Charsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserStackTestSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowserStackTestSession.class);
    private static final String BROWSER_SESSION_URL = "https://%s:%s@api.browserstack.com/automate/sessions/%s.json";
    private static final String BUILD_INFO_URL = "https://%s:%s@api.browserstack.com/automate/builds.json";
    private final String browserStackUsername;
    private final String browserStackKey;
    private final String sessionId;
    private final Gson gson = new Gson();

    public BrowserStackTestSession(String browserStackUsername, String browserStackKey, String sessionId) {
        this.browserStackUsername = browserStackUsername;
        this.browserStackKey = browserStackKey;
        this.sessionId = sessionId;
    }

    public void updateTestResultFor(TestOutcome testOutcome) {
        try {
            HttpPut putRequest = new HttpPut(this.getSessionUri());
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("status", this.browserstackCompatibleResultOf(testOutcome)));
            nameValuePairs.add(new BasicNameValuePair("reason", testOutcome.getErrorMessage()));
            putRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            HttpClientBuilder.create().build().execute((HttpUriRequest)putRequest);
        }
        catch (IOException e) {
            LOGGER.error("Failed to update Browserstack results", (Throwable)e);
        }
    }

    public String getName() {
        return this.getSessionProperty("name");
    }

    public int getDuration() {
        return Integer.parseInt(this.getSessionProperty("duration"));
    }

    public String getOS() {
        return this.getSessionProperty("os");
    }

    public String getOS_Version() {
        return this.getSessionProperty("os_version");
    }

    public String getBrowserVersion() {
        return this.getSessionProperty("browser_version");
    }

    public String getBrowser() {
        return this.getSessionProperty("browser");
    }

    public String getDevice() {
        return this.getSessionProperty("device");
    }

    public String getStatus() {
        return this.getSessionProperty("status");
    }

    public String getHashedId() {
        return this.getSessionProperty("hashed_id");
    }

    public String getReason() {
        return this.getSessionProperty("reason");
    }

    public String getBuildName() {
        return this.getSessionProperty("build_name");
    }

    public String getProjectName() {
        return this.getSessionProperty("project_name");
    }

    public String getTestPriority() {
        return this.getSessionProperty("test_priority");
    }

    public String getLogs() {
        return this.getSessionProperty("logs");
    }

    public String getBrowserstackStatus() {
        return this.getSessionProperty("browserstack_status");
    }

    public String getCreatedAt() {
        return this.getSessionProperty("created_at");
    }

    public String getBrowserUrl() {
        return this.getSessionProperty("browser_url");
    }

    public String getPublicUrl() {
        return this.getSessionProperty("public_url");
    }

    public String getAppiumLogsUrl() {
        return this.getSessionProperty("appium_logs_url");
    }

    public String getVideoUrl() {
        return this.getSessionProperty("video_url");
    }

    public String getBrowserConsoleLogsUrl() {
        return this.getSessionProperty("browser_console_logs_url");
    }

    public String getHarLogsUrl() {
        return this.getSessionProperty("har_logs_url");
    }

    public String getSeleniumLogsUrl() {
        return this.getSessionProperty("selenium_logs_url");
    }

    private String getSessionProperty(String propertyName) {
        JsonElement sessionElement = null;
        if (this.browserStackUsername == null || this.browserStackKey == null) {
            return null;
        }
        try {
            HttpGet querySessionInfo = new HttpGet(this.getSessionUri());
            HttpEntity sessionDetails = HttpClientBuilder.create().build().execute((HttpUriRequest)querySessionInfo).getEntity();
            String sessionBody = EntityUtils.toString((HttpEntity)sessionDetails, (Charset)this.charsetOf(sessionDetails));
            sessionElement = (JsonElement)this.gson.fromJson(sessionBody, JsonElement.class);
        }
        catch (JsonSyntaxException | IOException e) {
            LOGGER.error("Failed to connect to Browserstack API.", e);
        }
        if (sessionElement == null) {
            return null;
        }
        JsonElement automationSession = sessionElement.getAsJsonObject().get("automation_session");
        return automationSession.getAsJsonObject().get(propertyName).getAsString();
    }

    private Charset charsetOf(HttpEntity entity) {
        Header encodingHeader = entity.getContentEncoding();
        return encodingHeader == null ? StandardCharsets.UTF_8 : Charsets.toCharset((String)encodingHeader.getValue());
    }

    private String browserstackCompatibleResultOf(TestOutcome outcome) {
        switch (this.latestResultOf(outcome)) {
            case SUCCESS: {
                return "passed";
            }
            case FAILURE: 
            case ERROR: 
            case COMPROMISED: {
                return "failed";
            }
        }
        return "completed";
    }

    private URI getSessionUri() {
        URI uri = null;
        try {
            uri = new URI(String.format(BROWSER_SESSION_URL, this.browserStackUsername, this.browserStackKey, this.sessionId));
        }
        catch (URISyntaxException e) {
            LOGGER.error("Failed to parse Browserstack API url.", (Throwable)e);
        }
        return uri;
    }

    private TestResult latestResultOf(TestOutcome outcome) {
        if (outcome.isDataDriven()) {
            return ((TestStep)outcome.getLatestTopLevelTestStep().get()).getResult();
        }
        return outcome.getResult();
    }
}

