/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.browserstack;

import net.serenitybdd.core.webdriver.RemoteDriver;
import net.serenitybdd.core.webdriver.enhancers.AfterAWebdriverScenario;
import net.serenitybdd.plugins.browserstack.BrowserStackConfiguration;
import net.serenitybdd.plugins.browserstack.BrowserStackCredentials;
import net.serenitybdd.plugins.browserstack.BrowserStackTestSession;
import net.thucydides.core.model.ExternalLink;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.steps.TestContext;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.WebDriver;

public class AfterABrowserStackScenario
implements AfterAWebdriverScenario {
    public void apply(EnvironmentVariables environmentVariables, TestOutcome testOutcome, WebDriver driver) {
        if (!BrowserStackConfiguration.isDriverEnabled(driver) || !this.isActivated(environmentVariables)) {
            return;
        }
        String sessionId = RemoteDriver.of((WebDriver)driver).getSessionId().toString();
        String userName = BrowserStackCredentials.from(environmentVariables).getUser();
        String key = BrowserStackCredentials.from(environmentVariables).getAccessKey();
        BrowserStackTestSession browserStackTestSession = new BrowserStackTestSession(userName, key, sessionId);
        browserStackTestSession.updateTestResultFor(testOutcome);
        TestContext.forTheCurrentTest().recordBrowser(browserStackTestSession.getBrowser());
        TestContext.forTheCurrentTest().recordPlatform(browserStackTestSession.getOS());
        testOutcome.setContext(TestContext.forTheCurrentTest().getContext());
        String publicUrl = browserStackTestSession.getPublicUrl();
        testOutcome.setLink(new ExternalLink(publicUrl, "BrowserStack"));
    }

    public boolean isActivated(EnvironmentVariables environmentVariables) {
        return BrowserStackConfiguration.isActiveFor(environmentVariables);
    }
}

