/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.browserstack;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.model.TestOutcomeName;
import net.serenitybdd.core.webdriver.enhancers.BeforeAWebdriverScenario;
import net.serenitybdd.core.webdriver.enhancers.ProvidesRemoteWebdriverUrl;
import net.serenitybdd.plugins.browserstack.BrowserStackConfiguration;
import net.serenitybdd.plugins.browserstack.BrowserStackUri;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.environment.TestLocalEnvironmentVariables;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.SupportedWebDriver;
import org.openqa.selenium.MutableCapabilities;

public class BeforeABrowserStackScenario
implements BeforeAWebdriverScenario,
ProvidesRemoteWebdriverUrl {
    public MutableCapabilities apply(EnvironmentVariables environmentVariables, SupportedWebDriver driver, TestOutcome testOutcome, MutableCapabilities capabilities) {
        if (!BrowserStackConfiguration.isActiveFor(environmentVariables)) {
            return capabilities;
        }
        Optional remoteUrl = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL);
        if (!remoteUrl.isPresent()) {
            String browserstackRemoteUrl = BrowserStackUri.definedIn(environmentVariables).getUri();
            TestLocalEnvironmentVariables.setProperty((String)ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL.getPropertyName(), (String)browserstackRemoteUrl);
        }
        HashMap newOptions = new HashMap();
        capabilities.setCapability("sessionName", TestOutcomeName.from((TestOutcome)testOutcome));
        Map currentOptions = (Map)capabilities.getCapability("bstack:options");
        if (currentOptions != null) {
            newOptions.putAll(currentOptions);
        }
        capabilities.setCapability("bstack:options", newOptions);
        return capabilities;
    }

    public boolean isActivated(EnvironmentVariables environmentVariables) {
        return BrowserStackConfiguration.isActiveFor(environmentVariables);
    }

    public Optional<String> remoteUrlDefinedIn(EnvironmentVariables environmentVariables) {
        return Optional.ofNullable(BrowserStackUri.definedIn(environmentVariables).getUri());
    }
}

