/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.browserstack;

import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.webdriver.RemoteDriver;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.openqa.selenium.WebDriver;

class BrowserStackConfiguration {
    public static final String BROWSERSTACK_OPTIONS = "\"bstack:options\"";
    public static final String BROWSERSTACK_OPTIONS_PATH = "webdriver.capabilities.\"bstack:options\"";

    BrowserStackConfiguration() {
    }

    static boolean isActiveFor(EnvironmentVariables environmentVariables) {
        if (EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getBooleanProperty("browserstack.active", false)) {
            return true;
        }
        if (!EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getPropertiesWithPrefix(BROWSERSTACK_OPTIONS_PATH).isEmpty()) {
            return true;
        }
        return EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{"webdriver.remote.url"}).orElse("").contains("browserstack");
    }

    public static boolean isDriverEnabled(WebDriver driver) {
        if (driver == null || !RemoteDriver.isARemoteDriver((WebDriver)driver) || RemoteDriver.isStubbed((WebDriver)driver)) {
            return false;
        }
        if (driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)driver).isInstantiated();
        }
        return true;
    }
}

