/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.browserstack;

import java.util.Optional;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.util.EnvironmentVariables;

class BrowserStackCredentials {
    private final EnvironmentVariables environmentVariables;

    public BrowserStackCredentials(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static BrowserStackCredentials from(EnvironmentVariables environmentVariables) {
        return new BrowserStackCredentials(environmentVariables);
    }

    public String getUser() {
        String userDefinedInSerenityConf = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(new String[]{"browserstack.user"}).orElse("");
        return Optional.ofNullable(this.environmentVariables.getValue("BROWSERSTACK_USER")).orElse(userDefinedInSerenityConf);
    }

    public String getAccessKey() {
        String keyDefinedInSerenityConf = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(new String[]{"browserstack.key"}).orElse("");
        return Optional.ofNullable(this.environmentVariables.getValue("BROWSERSTACK_KEY")).orElse(keyDefinedInSerenityConf);
    }

    public boolean areDefined() {
        return !this.getUser().isEmpty() && !this.getAccessKey().isEmpty();
    }
}

