/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.lang.reflect.Method;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.NameConverter;
import net.thucydides.core.webdriver.capabilities.RemoteDriverCapabilities;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SauceRemoteDriverCapabilities
implements RemoteDriverCapabilities {
    private final EnvironmentVariables environmentVariables;

    public SauceRemoteDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public String getUrl() {
        return ThucydidesSystemProperty.SAUCELABS_URL.from(this.environmentVariables);
    }

    @Override
    public DesiredCapabilities getCapabilities(DesiredCapabilities capabilities) {
        this.configureBrowserVersion(capabilities);
        this.configureTargetPlatform(capabilities);
        this.configureTestName(capabilities);
        capabilities.setJavascriptEnabled(true);
        return capabilities;
    }

    private void configureBrowserVersion(DesiredCapabilities capabilities) {
        String driverVersion = ThucydidesSystemProperty.SAUCELABS_DRIVER_VERSION.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)driverVersion)) {
            capabilities.setCapability("version", driverVersion);
        }
    }

    private void configureTargetPlatform(DesiredCapabilities capabilities) {
        this.setAppropriateSaucelabsPlatformVersion(capabilities);
        if (capabilities.getBrowserName().equals("safari")) {
            this.setAppropriateSaucelabsPlatformVersionForSafari(capabilities);
        }
    }

    private void setAppropriateSaucelabsPlatformVersion(DesiredCapabilities capabilities) {
        String platformValue = ThucydidesSystemProperty.SAUCELABS_TARGET_PLATFORM.from(this.environmentVariables);
        if (StringUtils.isEmpty((CharSequence)platformValue)) {
            return;
        }
        if (platformValue.equalsIgnoreCase("snowleopard")) {
            capabilities.setCapability("platform", "OS X 10.6");
        } else if (platformValue.equalsIgnoreCase("mountainlion")) {
            capabilities.setCapability("platform", "OS X 10.8");
        } else if (platformValue.equalsIgnoreCase("mavericks")) {
            capabilities.setCapability("platform", "OS X 10.9");
        } else if (platformValue.equalsIgnoreCase("yosemite")) {
            capabilities.setCapability("platform", "OS X 10.10");
        } else {
            capabilities.setCapability("platform", this.platformFrom(platformValue));
        }
    }

    private void setAppropriateSaucelabsPlatformVersionForSafari(DesiredCapabilities capabilities) {
        if (ThucydidesSystemProperty.SAUCELABS_TARGET_PLATFORM.from(this.environmentVariables).equalsIgnoreCase("mac")) {
            String browserVersion = ThucydidesSystemProperty.SAUCELABS_DRIVER_VERSION.from(this.environmentVariables);
            if (browserVersion.equals("5")) {
                capabilities.setCapability("platform", "OS X 10.6");
            } else if (browserVersion.equals("6")) {
                capabilities.setCapability("platform", "OS X 10.8");
            } else if (browserVersion.equals("7")) {
                capabilities.setCapability("platform", "OS X 10.9");
            } else if (browserVersion.equals("8")) {
                capabilities.setCapability("platform", "OS X 10.10");
            }
        }
    }

    private void configureTestName(DesiredCapabilities capabilities) {
        String testName = ThucydidesSystemProperty.SAUCELABS_TEST_NAME.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)testName)) {
            capabilities.setCapability("name", testName);
        } else {
            String guessedTestName = this.bestGuessOfTestName();
            if (guessedTestName != null) {
                capabilities.setCapability("name", this.bestGuessOfTestName());
            }
        }
    }

    private String bestGuessOfTestName() {
        for (StackTraceElement elt : Thread.currentThread().getStackTrace()) {
            try {
                Class<?> callingClass = Class.forName(elt.getClassName());
                Method callingMethod = callingClass.getMethod(elt.getMethodName(), new Class[0]);
                if (this.isATestMethod(callingMethod)) {
                    return NameConverter.humanize(elt.getMethodName());
                }
                if (!this.isASetupMethod(callingMethod)) continue;
                return NameConverter.humanize(callingClass.getSimpleName());
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isATestMethod(Method callingMethod) {
        return callingMethod.getAnnotation(Test.class) != null;
    }

    private boolean isASetupMethod(Method callingMethod) {
        return callingMethod.getAnnotation(Before.class) != null || callingMethod.getAnnotation(BeforeClass.class) != null;
    }

    private Platform platformFrom(String platformValue) {
        return Platform.valueOf((String)platformValue.toUpperCase());
    }
}

