/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.images.ResizableImage;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Screenshot;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.ReportOptions;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.TagFilter;
import net.thucydides.core.reports.html.screenshots.ScreenshotFormatter;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.util.VersionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlAcceptanceTestReporter
extends HtmlReporter
implements AcceptanceTestReporter {
    private static final String DEFAULT_ACCEPTANCE_TEST_REPORT = "freemarker/default.ftl";
    private static final String DEFAULT_ACCEPTANCE_TEST_SCREENSHOT = "freemarker/screenshots.ftl";
    private static final int MAXIMUM_SCREENSHOT_WIDTH = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlAcceptanceTestReporter.class);
    private String qualifier;
    private final IssueTracking issueTracking;
    private RequirementsService requirementsService;
    private ReportNameProvider reportNameProvider = new ReportNameProvider();

    @Override
    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public HtmlAcceptanceTestReporter() {
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.requirementsService = (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class);
    }

    public HtmlAcceptanceTestReporter(EnvironmentVariables environmentVariables, IssueTracking issueTracking) {
        super(environmentVariables);
        this.issueTracking = issueTracking;
        this.requirementsService = (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class);
    }

    @Override
    public String getName() {
        return "html";
    }

    @Override
    public File generateReportFor(TestOutcome testOutcome, TestOutcomes allTestOutcomes) throws IOException {
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        TestOutcome storedTestOutcome = testOutcome.withQualifier(this.qualifier);
        HashMap<String, Object> context = new HashMap<String, Object>();
        this.addTestOutcomeToContext(storedTestOutcome, allTestOutcomes, context);
        if (this.containsScreenshots(storedTestOutcome)) {
            this.generateScreenshotReportsFor(storedTestOutcome, allTestOutcomes);
        }
        this.addFormattersToContext(context);
        this.addTimestamp(testOutcome, context);
        String htmlContents = this.mergeTemplate(DEFAULT_ACCEPTANCE_TEST_REPORT).usingContext(context);
        this.copyResourcesToOutputDirectory();
        String reportFilename = this.reportFor(storedTestOutcome);
        LOGGER.info("GENERATING HTML REPORT FOR " + storedTestOutcome.getCompleteName() + (this.qualifier != null ? "/" + this.qualifier : "") + " => " + reportFilename);
        return this.writeReportToOutputDirectory(reportFilename, htmlContents);
    }

    private boolean containsScreenshots(TestOutcome testOutcome) {
        return Iterables.any(testOutcome.getFlattenedTestSteps(), this.hasScreenshot());
    }

    private Predicate<TestStep> hasScreenshot() {
        return new Predicate<TestStep>(){

            public boolean apply(TestStep testStep) {
                return testStep.getScreenshots() != null && !testStep.getScreenshots().isEmpty();
            }
        };
    }

    private void addTestOutcomeToContext(TestOutcome testOutcome, TestOutcomes allTestOutcomes, Map<String, Object> context) {
        context.put("allTestOutcomes", allTestOutcomes);
        context.put("testOutcome", testOutcome);
        context.put("currentTag", TestTag.EMPTY_TAG);
        context.put("inflection", Inflector.getInstance());
        context.put("requirementTypes", this.requirementsService.getRequirementTypes());
        this.addParentRequirmentFieldToContext(testOutcome, context);
        this.addTimestamp(testOutcome, context);
    }

    private void addParentRequirmentFieldToContext(TestOutcome testOutcome, Map<String, Object> context) {
        Optional<Requirement> parentRequirement = this.requirementsService.getParentRequirementFor(testOutcome);
        Optional featureOrStory = Optional.fromNullable((Object)testOutcome.getUserStory());
        String parentTitle = null;
        if (parentRequirement.isPresent()) {
            parentTitle = ((Requirement)parentRequirement.get()).getName();
            context.put("parentRequirement", parentRequirement);
            context.put("featureOrStory", Optional.absent());
            context.put("parentTitle", parentTitle);
            context.put("parentLink", this.reportNameProvider.forRequirement((Requirement)parentRequirement.get()));
        } else if (featureOrStory.isPresent()) {
            parentTitle = ((Story)featureOrStory.get()).getName();
            context.put("parentRequirement", Optional.absent());
            context.put("featureOrStory", featureOrStory);
            context.put("parentTitle", parentTitle);
            context.put("parentLink", this.reportNameProvider.forTag(((Story)featureOrStory.get()).asTag()));
        }
        TagFilter tagFilter = new TagFilter(this.getEnvironmentVariables());
        Set<TestTag> filteredTags = tagFilter.removeTagsOfType(testOutcome.getTags(), "story");
        if (parentTitle != null) {
            filteredTags = tagFilter.removeTagsWithName(filteredTags, parentTitle);
        }
        context.put("filteredTags", filteredTags);
    }

    private void addFormattersToContext(Map<String, Object> context) {
        Formatter formatter = new Formatter(this.issueTracking);
        context.put("reportOptions", new ReportOptions(this.getEnvironmentVariables()));
        context.put("formatter", formatter);
        context.put("reportName", new ReportNameProvider());
        context.put("absoluteReportName", new ReportNameProvider());
        context.put("reportOptions", new ReportOptions(this.getEnvironmentVariables()));
        VersionProvider versionProvider = new VersionProvider(this.getEnvironmentVariables());
        context.put("serenityVersionNumber", versionProvider.getVersion());
        context.put("buildNumber", versionProvider.getBuildNumberText());
    }

    private void generateScreenshotReportsFor(TestOutcome testOutcome, TestOutcomes allTestOutcomes) throws IOException {
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        List<Screenshot> screenshots = this.expandScreenshots(testOutcome.getScreenshots());
        String screenshotReport = testOutcome.getReportName() + "_screenshots.html";
        HashMap<String, Object> context = new HashMap<String, Object>();
        this.addTestOutcomeToContext(testOutcome, allTestOutcomes, context);
        this.addFormattersToContext(context);
        context.put("screenshots", screenshots);
        context.put("narrativeView", testOutcome.getReportName());
        String htmlContents = this.mergeTemplate(DEFAULT_ACCEPTANCE_TEST_SCREENSHOT).usingContext(context);
        this.writeReportToOutputDirectory(screenshotReport, htmlContents);
    }

    private List<Screenshot> expandScreenshots(List<Screenshot> screenshots) throws IOException {
        return Lambda.convert(screenshots, (Converter)new ExpandedScreenshotConverter(this.maxScreenshotHeightIn(screenshots)));
    }

    private boolean shouldKeepOriginalScreenshots() {
        return ThucydidesSystemProperty.THUCYDIDES_KEEP_UNSCALED_SCREENSHOTS.booleanFrom(this.getEnvironmentVariables());
    }

    private int maxScreenshotHeightIn(List<Screenshot> screenshots) throws IOException {
        int maxHeight = 0;
        for (Screenshot screenshot : screenshots) {
            File screenshotFile = new File(this.getOutputDirectory(), screenshot.getFilename());
            if (!screenshotFile.exists()) continue;
            maxHeight = this.maxHeightOf(maxHeight, screenshotFile);
        }
        return maxHeight;
    }

    private int maxHeightOf(int maxHeight, File screenshotFile) throws IOException {
        int height = ResizableImage.loadFrom(screenshotFile).getHeight();
        int width = ResizableImage.loadFrom(screenshotFile).getWitdh();
        if (width > 1000) {
            height = (int)((double)height * 1.0 * (1000.0 / (double)width));
        }
        if (height > maxHeight) {
            maxHeight = height;
        }
        return maxHeight;
    }

    private String reportFor(TestOutcome testOutcome) {
        return testOutcome.withQualifier(this.qualifier).getReportName(ReportType.HTML);
    }

    @Override
    public Optional<OutcomeFormat> getFormat() {
        return Optional.of((Object)((Object)OutcomeFormat.HTML));
    }

    private class ExpandedScreenshotConverter
    implements Converter<Screenshot, Screenshot> {
        private final int maxHeight;

        public ExpandedScreenshotConverter(int maxHeight) {
            this.maxHeight = maxHeight;
        }

        public Screenshot convert(Screenshot screenshot) {
            try {
                return ScreenshotFormatter.forScreenshot(screenshot).inDirectory(HtmlAcceptanceTestReporter.this.getOutputDirectory()).keepOriginals(HtmlAcceptanceTestReporter.this.shouldKeepOriginalScreenshots()).expandToHeight(this.maxHeight);
            }
            catch (IOException e) {
                LOGGER.info("NOTE: I couldn't convert scaled screenshot for {}: {}", new Object[]{screenshot.getFilename(), e.getMessage(), e});
                return screenshot;
            }
        }
    }
}

