/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import gherkin.formatter.Formatter;
import gherkin.formatter.model.Tag;
import gherkin.parser.Parser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.requirements.model.Narrative;
import net.thucydides.core.requirements.model.cucumber.CucumberFeatureListener;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.io.FileUtils;

public class CucumberParser {
    private final String locale;

    public CucumberParser() {
        this((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public CucumberParser(EnvironmentVariables environmentVariables) {
        this.locale = ThucydidesSystemProperty.FEATURE_FILE_LANGUAGE.from(environmentVariables, "en");
    }

    public CucumberParser(String locale) {
        this.locale = locale;
    }

    public Optional<Narrative> loadFeatureNarrative(File narrativeFile) {
        CucumberFeatureListener gherkinStructure = new CucumberFeatureListener();
        Parser parser = new Parser((Formatter)gherkinStructure, true, "root", false, this.locale);
        try {
            String gherkinScenarios = this.filterOutCommentsFrom(FileUtils.readFileToString((File)narrativeFile));
            parser.parse(gherkinScenarios, narrativeFile.getName(), Integer.valueOf(0));
            String cardNumber = this.findCardNumberInTags(gherkinStructure.getFeature().getTags());
            List<String> versionNumbers = this.findVersionNumberInTags(gherkinStructure.getFeature().getTags());
            String title = gherkinStructure.getFeature().getName();
            String text = gherkinStructure.getFeature().getDescription();
            return Optional.of((Object)new Narrative((Optional<String>)Optional.fromNullable((Object)title), (Optional<String>)Optional.fromNullable((Object)cardNumber), versionNumbers, "feature", text));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return Optional.absent();
        }
    }

    private String filterOutCommentsFrom(String gherkin) {
        StringBuilder filteredGherkin = new StringBuilder();
        Scanner scanner = new Scanner(gherkin);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.trim().startsWith("#")) continue;
            filteredGherkin.append(line).append(System.lineSeparator());
        }
        scanner.close();
        return filteredGherkin.toString();
    }

    private String findCardNumberInTags(List<Tag> tags) {
        for (Tag tag : tags) {
            if (tag.getName().toLowerCase().startsWith("@issue:")) {
                return tag.getName().replaceAll("@issue:", "");
            }
            if (!tag.getName().toLowerCase().startsWith("@issues:")) continue;
            String issueNumberList = tag.getName().replaceAll("@issues:", "");
            List issueNumberTags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)issueNumberList);
            return (String)issueNumberTags.get(0);
        }
        return null;
    }

    private List<String> findVersionNumberInTags(List<Tag> tags) {
        ArrayList versionNumbers = Lists.newArrayList();
        for (Tag tag : tags) {
            if (tag.getName().toLowerCase().startsWith("@version:")) {
                versionNumbers.add(tag.getName().replaceAll("@version:", ""));
                continue;
            }
            if (!tag.getName().toLowerCase().startsWith("@versions:")) continue;
            String versionNumberList = tag.getName().replaceAll("@versions:", "");
            List versionNumberTags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)versionNumberList);
            versionNumbers.addAll(versionNumberTags);
        }
        return versionNumbers;
    }
}

