/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps.stepdata;

import au.com.bytecode.opencsv.CSVReader;
import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thucydides.core.csv.FailedToInitializeTestData;
import net.thucydides.core.csv.FieldName;
import net.thucydides.core.csv.InstanceBuilder;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.FilePathParser;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.stepdata.TestDataSource;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVTestDataSource
implements TestDataSource {
    private char separator;
    private final char quotechar;
    private final char escape;
    private final int skipLines;
    private final String instantiatedPath;
    private List<String[]> csvDataRows;
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVTestDataSource.class);
    FilePathParser testDataSourcePath = new FilePathParser((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());

    public CSVTestDataSource(String path, char separatorValue, char quotechar, char escape, int skipLines) throws IOException {
        this.separator = separatorValue;
        this.quotechar = quotechar;
        this.escape = escape;
        this.skipLines = skipLines;
        this.instantiatedPath = this.testDataSourcePath.getInstanciatedPath(path);
    }

    List<String[]> getDataRows() {
        if (this.csvDataRows == null) {
            try (Reader reader = this.getDataFileFor(this.instantiatedPath);){
                this.csvDataRows = this.getCSVDataFrom(reader);
            }
            catch (IOException e) {
                LOGGER.error("Could not read test data file from {}", (Object)this.instantiatedPath, (Object)e);
            }
        }
        return this.csvDataRows;
    }

    public CSVTestDataSource(String path) throws IOException {
        this(path, ',', '\"', '\\', 0);
    }

    public CSVTestDataSource(String path, char separatorValue) throws IOException {
        this(path, separatorValue, '\"', '\\', 0);
    }

    public CSVTestDataSource(String path, char separatorValue, char quotechar, char escape) throws IOException {
        this(path, separatorValue, quotechar, escape, 0);
    }

    public static boolean validTestDataPath(String path) {
        if (CSVTestDataSource.validFileSystemPath(path) || CSVTestDataSource.isAClasspathResource(path)) {
            return true;
        }
        URL testDataUrl = CSVTestDataSource.class.getClassLoader().getResource(path);
        return testDataUrl != null && new File(testDataUrl.getFile()).exists();
    }

    private Reader getDataFileFor(String path) throws FileNotFoundException {
        Preconditions.checkNotNull((Object)path, (Object)"Test data source was not defined");
        if (CSVTestDataSource.isAClasspathResource(path)) {
            return new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(path));
        }
        if (CSVTestDataSource.validFileSystemPath(path)) {
            return new FileReader(new File(path));
        }
        throw new FileNotFoundException("Could not load test data from " + path);
    }

    private static boolean isAClasspathResource(String path) {
        return CSVTestDataSource.class.getClassLoader().getResourceAsStream(path) != null;
    }

    private static boolean validFileSystemPath(String path) {
        File file = new File(path);
        return file.exists();
    }

    protected List<String[]> getCSVDataFrom(Reader testDataReader) throws IOException {
        List rows;
        try (CSVReader reader = new CSVReader(testDataReader, this.separator, this.quotechar, this.escape, this.skipLines);){
            rows = reader.readAll();
        }
        return rows;
    }

    protected List<Map<String, String>> loadTestDataFrom(List<String[]> rows) throws IOException {
        ArrayList<Map<String, String>> loadedData = new ArrayList<Map<String, String>>();
        String[] titleRow = rows.get(0);
        for (int i = 1; i < rows.size(); ++i) {
            String[] dataRow = rows.get(i);
            loadedData.add(this.dataEntryFrom(titleRow, dataRow));
        }
        return loadedData;
    }

    private Map<String, String> dataEntryFrom(String[] titleRow, String[] dataRow) {
        HashMap<String, String> dataset = new HashMap<String, String>();
        for (int column = 0; column < titleRow.length; ++column) {
            if (column >= dataRow.length) continue;
            String title = titleRow[column].trim();
            String value = dataRow[column].trim();
            dataset.put(title, value);
        }
        return dataset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Map<String, String>> getData() {
        try (Reader reader = this.getDataFileFor(this.instantiatedPath);){
            List<Map<String, String>> list = this.loadTestDataFrom(this.getCSVDataFrom(reader));
            return list;
        }
        catch (IOException e) {
            LOGGER.error("Could not read test data file from {}", (Object)this.instantiatedPath, (Object)e);
            return ImmutableList.of();
        }
    }

    @Override
    public List<String> getHeaders() {
        return Lambda.convert((Object)this.getTitleRow(), (Converter)new Converter<String, String>(){

            public String convert(String str) {
                return StringUtils.strip((String)str);
            }
        });
    }

    private String[] getTitleRow() {
        return this.getDataRows().get(0);
    }

    @Override
    public <T> List<T> getDataAsInstancesOf(Class<T> clazz, Object ... constructorArgs) {
        List<Map<String, String>> data = this.getData();
        ArrayList<T> resultsList = new ArrayList<T>();
        for (Map<String, String> rowData : data) {
            resultsList.add(this.newInstanceFrom(clazz, rowData, constructorArgs));
        }
        return resultsList;
    }

    @Override
    public <T> List<T> getInstanciatedInstancesFrom(Class<T> clazz, StepFactory factory) {
        List<Map<String, String>> data = this.getData();
        ArrayList<T> resultsList = new ArrayList<T>();
        for (Map<String, String> rowData : data) {
            resultsList.add(this.newInstanceFrom(clazz, factory, rowData));
        }
        return resultsList;
    }

    @Override
    public TestDataSource separatedBy(char newSeparator) {
        this.separator = newSeparator;
        return this;
    }

    private <T> T newInstanceFrom(Class<T> clazz, Map<String, String> rowData, Object ... constructorArgs) {
        T newObject = this.createNewInstanceOf(clazz, constructorArgs);
        this.assignPropertiesFromTestData(clazz, rowData, newObject);
        return newObject;
    }

    private <T> T newInstanceFrom(Class<T> clazz, StepFactory factory, Map<String, String> rowData) {
        T newObject = factory.getUniqueStepLibraryFor(clazz);
        this.assignPropertiesFromTestData(clazz, rowData, newObject);
        return newObject;
    }

    private <T> void assignPropertiesFromTestData(Class<T> clazz, Map<String, String> rowData, T newObject) {
        Set<String> propertyNames = rowData.keySet();
        boolean validPropertyFound = false;
        for (String columnHeading : propertyNames) {
            String value = rowData.get(columnHeading);
            String property = FieldName.from(columnHeading).inNormalizedForm();
            if (!this.assignPropertyValue(newObject, property, value)) continue;
            validPropertyFound = true;
        }
        if (!validPropertyFound) {
            throw new FailedToInitializeTestData("No properties or public fields matching the data columns were found or could be assigned for the class " + clazz.getName() + "using test data: " + rowData);
        }
    }

    protected <T> T createNewInstanceOf(Class<T> clazz, Object ... constructorArgs) {
        try {
            return InstanceBuilder.newInstanceOf(clazz, constructorArgs);
        }
        catch (Exception e) {
            LOGGER.error("Could not create test data bean", (Throwable)e);
            throw new FailedToInitializeTestData("Could not create test data beans", e);
        }
    }

    protected <T> boolean assignPropertyValue(T newObject, String property, String value) {
        boolean valueWasAssigned = true;
        try {
            InstanceBuilder.inObject(newObject).setPropertyValue(property, value);
        }
        catch (FailedToInitializeTestData e) {
            valueWasAssigned = false;
        }
        return valueWasAssigned;
    }
}

