/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.stacktrace;

import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.failures.FailureAnalysis;
import net.thucydides.core.model.stacktrace.FailureCause;
import net.thucydides.core.model.stacktrace.StackTraceSanitizer;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.WebdriverAssertionError;

public class RootCauseAnalyzer {
    private final Throwable thrownException;
    private final FailureAnalysis failureAnalysis;
    private final EnvironmentVariables environmentVariables;

    public RootCauseAnalyzer(Throwable thrownException) {
        this.thrownException = thrownException;
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        this.failureAnalysis = new FailureAnalysis(this.environmentVariables);
    }

    public FailureCause getRootCause() {
        Throwable originalException = this.originalExceptionFrom(this.thrownException);
        StackTraceSanitizer stackTraceSanitizer = StackTraceSanitizer.forStackTrace(originalException.getStackTrace());
        return new FailureCause(originalException, stackTraceSanitizer.getSanitizedStackTrace());
    }

    private Throwable originalExceptionFrom(Throwable thrownException) {
        if (!(thrownException instanceof WebdriverAssertionError) && (thrownException instanceof SerenityManagedException || thrownException instanceof AssertionError)) {
            return thrownException;
        }
        if (this.failureAnalysis.reportAsError(thrownException.getClass())) {
            return thrownException;
        }
        if (this.failureAnalysis.reportAsCompromised(thrownException.getClass())) {
            return thrownException;
        }
        if (this.failureAnalysis.reportAsFailure(thrownException.getClass())) {
            return thrownException;
        }
        if (this.failureAnalysis.reportAsPending(thrownException.getClass())) {
            return thrownException;
        }
        return thrownException.getCause() != null ? thrownException.getCause() : thrownException;
    }

    public String getClassname() {
        return this.getRootCause().getErrorType();
    }

    public String getMessage() {
        return this.getRootCause().getMessage() != null ? this.getRootCause().getMessage().replace("java.lang.AssertionError", "") : this.getRootCause().getMessage();
    }
}

