/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.xml;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestLoader;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.xml.TestOutcomeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLTestOutcomeReporter
implements AcceptanceTestReporter,
AcceptanceTestLoader {
    private File outputDirectory;
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLTestOutcomeReporter.class);
    private transient String qualifier;

    @Override
    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public void setResourceDirectory(String resourceDirectoryPath) {
    }

    @Override
    public String getName() {
        return "xml";
    }

    @Override
    public Optional<OutcomeFormat> getFormat() {
        return Optional.of((Object)((Object)OutcomeFormat.XML));
    }

    @Override
    public File generateReportFor(TestOutcome testOutcome, TestOutcomes allTestOutcomes) throws IOException {
        TestOutcome storedTestOutcome = testOutcome.withQualifier(this.qualifier);
        Preconditions.checkNotNull((Object)this.outputDirectory);
        XStream xstream = new XStream();
        xstream.alias("acceptance-test-run", TestOutcome.class);
        xstream.registerConverter((Converter)this.usingXmlConverter());
        String reportFilename = this.reportFor(storedTestOutcome);
        String unique = UUID.randomUUID().toString();
        File temporary = new File(this.getOutputDirectory(), reportFilename.concat(unique));
        File report = new File(this.getOutputDirectory(), reportFilename);
        report.createNewFile();
        LOGGER.debug("Generating XML report for {} to file {} (using temp file {})", new Object[]{testOutcome.getTitle(), report.getAbsolutePath(), temporary.getAbsolutePath()});
        try (FileOutputStream outputStream = new FileOutputStream(temporary);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);){
            xstream.toXML((Object)storedTestOutcome, (Writer)writer);
            writer.flush();
            LOGGER.debug("XML report generated ({} bytes) {}", (Object)report.getAbsolutePath(), (Object)report.length());
        }
        Files.move(temporary.toPath(), report.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        return report;
    }

    private TestOutcomeConverter usingXmlConverter() {
        return new TestOutcomeConverter();
    }

    private String reportFor(TestOutcome testOutcome) {
        return testOutcome.withQualifier(this.qualifier).getReportName(ReportType.XML);
    }

    @Override
    public Optional<TestOutcome> loadReportFrom(Path reportFile) {
        return this.loadReportFrom(reportFile.toFile());
    }

    /*
     * Exception decompiling
     */
    @Override
    public Optional<TestOutcome> loadReportFrom(File reportFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public List<TestOutcome> loadReportsFrom(Path outputDirectory) {
        return this.loadReportsFrom(outputDirectory.toFile());
    }

    @Override
    public List<TestOutcome> loadReportsFrom(File outputDirectory) {
        File[] reportFiles = this.getAllXMLFilesFrom(outputDirectory);
        ArrayList testOutcomes = Lists.newArrayList();
        if (reportFiles != null) {
            for (File reportFile : reportFiles) {
                testOutcomes.addAll(this.loadReportFrom(reportFile).asSet());
            }
        }
        return testOutcomes;
    }

    private File[] getAllXMLFilesFrom(File reportsDirectory) {
        return reportsDirectory.listFiles(new XmlFilenameFilter());
    }

    private static final class XmlFilenameFilter
    implements FilenameFilter {
        private XmlFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String filename) {
            return filename.toLowerCase(Locale.getDefault()).endsWith(".xml");
        }
    }
}

