/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps.construction;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.ScenarioSteps;
import net.thucydides.core.steps.construction.ConstructionStrategy;

public class StepLibraryConstructionStrategy {
    private final Class<?> stepLibraryClass;

    private StepLibraryConstructionStrategy(Class<?> stepLibraryClass) {
        this.stepLibraryClass = stepLibraryClass;
    }

    public static StepLibraryConstructionStrategy forClass(Class<?> scenarioStepsClass) {
        return new StepLibraryConstructionStrategy(scenarioStepsClass);
    }

    public ConstructionStrategy getStrategy() {
        if (this.isWebdriverStepClass(this.stepLibraryClass)) {
            return ConstructionStrategy.STEP_LIBRARY_WITH_WEBDRIVER;
        }
        if (this.hasAConstructorWithParameters(this.stepLibraryClass)) {
            return ConstructionStrategy.CONSTRUCTOR_WITH_PARAMETERS;
        }
        if (this.hasAPagesField(this.stepLibraryClass)) {
            return ConstructionStrategy.STEP_LIBRARY_WITH_PAGES;
        }
        return ConstructionStrategy.DEFAULT_CONSTRUCTOR;
    }

    private <T> boolean isWebdriverStepClass(Class<T> stepLibraryClass) {
        return this.isAScenarioStepClass(stepLibraryClass) || this.hasAPagesConstructor(stepLibraryClass);
    }

    private <T> boolean hasAPagesConstructor(Class<T> stepLibraryClass) {
        ImmutableSet constructors = ImmutableSet.copyOf((Object[])stepLibraryClass.getDeclaredConstructors());
        return Iterables.any((Iterable)constructors, this.withASinglePagesParameter());
    }

    private <T> boolean hasAConstructorWithParameters(Class<T> stepLibraryClass) {
        ImmutableSet constructors = ImmutableSet.copyOf((Object[])stepLibraryClass.getDeclaredConstructors());
        return Iterables.any((Iterable)constructors, this.withAnyParameters());
    }

    private <T> boolean hasAPagesField(Class<T> stepLibraryClass) {
        ImmutableSet fields = ImmutableSet.copyOf(Fields.of(stepLibraryClass).allFields());
        return Iterables.any((Iterable)fields, this.ofTypePages());
    }

    private Predicate<Constructor<?>> withAnyParameters() {
        return new Predicate<Constructor<?>>(){

            public boolean apply(Constructor<?> constructor) {
                return constructor.getParameterTypes().length > 0;
            }
        };
    }

    private Predicate<Constructor<?>> withASinglePagesParameter() {
        return new Predicate<Constructor<?>>(){

            public boolean apply(Constructor<?> constructor) {
                return constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0] == Pages.class;
            }
        };
    }

    private <T> boolean isAScenarioStepClass(Class<T> stepLibraryClass) {
        return ScenarioSteps.class.isAssignableFrom(stepLibraryClass);
    }

    private Predicate<Field> ofTypePages() {
        return new Predicate<Field>(){

            public boolean apply(Field field) {
                return field.getType() == Pages.class;
            }
        };
    }
}

