/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.appium;

import ch.lambdaj.Lambda;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.PathProcessor;
import net.thucydides.core.webdriver.MobilePlatform;
import net.thucydides.core.webdriver.ThucydidesConfigurationException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openqa.selenium.remote.DesiredCapabilities;

public class AppiumConfiguration {
    private final String DEFAULT_URL = "http://127.0.0.1:4723/wd/hub";
    private final EnvironmentVariables environmentVariables;

    public AppiumConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static AppiumConfiguration from(EnvironmentVariables environmentVariables) {
        return new AppiumConfiguration(environmentVariables);
    }

    public MobilePlatform getTargetPlatform() {
        String targetPlatform = this.environmentVariables.getProperty("appium.platformName", "UNDEFINED");
        MobilePlatform platform = null;
        try {
            platform = MobilePlatform.valueOf(targetPlatform.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ThucydidesConfigurationException("The appium.platformName needs to be specified (either IOS or ANDROID)");
        }
        return platform;
    }

    public URL getUrl() {
        String url = this.environmentVariables.getProperty("appium.hub", "http://127.0.0.1:4723/wd/hub");
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ThucydidesConfigurationException("The appium.hub URL needs to be specified");
        }
    }

    public DesiredCapabilities getCapabilities() {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        Properties appiumProperties = this.getProperties();
        for (Object key : appiumProperties.keySet()) {
            capabilities.setCapability(key.toString(), appiumProperties.getProperty(key.toString()));
            capabilities.asMap();
        }
        return capabilities;
    }

    public Properties getProperties() {
        return this.appiumPropertiesFrom(this.environmentVariables);
    }

    private Properties appiumPropertiesFrom(EnvironmentVariables environmentVariables) {
        Properties appiumProperties = new Properties();
        List appiumKeys = Lambda.filter((Matcher)CoreMatchers.startsWith((String)"appium."), environmentVariables.getKeys());
        for (String key : appiumKeys) {
            String value = this.isAppProperty(key) ? this.appPathFrom(environmentVariables.getProperty(key)) : environmentVariables.getProperty(key);
            String simplifiedKey = key.replace("appium.", "");
            appiumProperties.setProperty(simplifiedKey, value.trim());
        }
        this.ensureAppOrBrowserPathDefinedIn(appiumProperties);
        return appiumProperties;
    }

    private void ensureAppOrBrowserPathDefinedIn(Properties appiumProperties) {
        if (!appiumProperties.containsKey("app") && !appiumProperties.containsKey("browserName")) {
            throw new ThucydidesConfigurationException("The browser under test or path to the app needs to be provided in the appium.app or appium.browserName property.");
        }
    }

    private String appPathFrom(String propertyValue) {
        return new PathProcessor().normalize(propertyValue);
    }

    private boolean isAppProperty(String key) {
        return key.equals("appium.app");
    }
}

