/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.annotations.findby.FindBy;
import net.serenitybdd.core.annotations.locators.SmartAnnotations;
import net.serenitybdd.core.pages.WebElementFacade;
import net.thucydides.core.annotations.locators.MethodTiming;
import net.thucydides.core.annotations.locators.SmartElementLocator;
import net.thucydides.core.annotations.locators.WithConfigurableTimeout;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.ConfigurableTimeouts;
import net.thucydides.core.webdriver.MobilePlatform;
import net.thucydides.core.webdriver.ThucydidesWebdriverManager;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.core.webdriver.exceptions.ElementNotFoundAfterTimeoutError;
import net.thucydides.core.webdriver.exceptions.ElementNotVisibleAfterTimeoutError;
import net.thucydides.core.webdriver.stubs.WebElementFacadeStub;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.Duration;
import org.openqa.selenium.support.ui.SlowLoadableComponent;
import org.openqa.selenium.support.ui.SystemClock;

public class SmartAjaxElementLocator
extends SmartElementLocator
implements WithConfigurableTimeout {
    public static final Duration ZERO_SECONDS = new Duration(0L, TimeUnit.SECONDS);
    protected Optional<Integer> annotatedTimeoutInSeconds;
    private final Clock clock;
    private final Field field;
    private final SearchContext searchContext;
    private final MobilePlatform platform;
    private static final List<WebElement> EMPTY_LIST_OF_WEBELEMENTS = Lists.newArrayList();

    public SmartAjaxElementLocator(SearchContext searchContext, Field field, MobilePlatform platform, int timeOutInSeconds) {
        this((Clock)new SystemClock(), searchContext, field, platform);
    }

    public SmartAjaxElementLocator(SearchContext searchContext, Field field, MobilePlatform platform) {
        this((Clock)new SystemClock(), searchContext, field, platform);
    }

    public SmartAjaxElementLocator(Clock clock, SearchContext searchContext, Field field, MobilePlatform platform) {
        super(searchContext, field, platform);
        this.annotatedTimeoutInSeconds = this.timeoutFrom(field);
        this.clock = clock;
        this.field = field;
        this.searchContext = searchContext instanceof WebDriverFacade ? (this.annotatedTimeoutInSeconds.isPresent() ? ((WebDriverFacade)searchContext).withTimeoutOf(new Duration((long)((Integer)this.annotatedTimeoutInSeconds.get()).intValue(), TimeUnit.SECONDS)) : searchContext) : (searchContext instanceof WebElementFacade ? (this.annotatedTimeoutInSeconds.isPresent() ? ((WebElementFacade)searchContext).withTimeoutOf((Integer)this.annotatedTimeoutInSeconds.get(), TimeUnit.SECONDS) : searchContext) : (searchContext instanceof WebDriver ? WebdriverProxyFactory.getFactory().proxyFor((WebDriver)searchContext) : searchContext));
        this.platform = platform;
    }

    private Optional<Integer> timeoutFrom(Field field) {
        FindBy findBy = field.getAnnotation(FindBy.class);
        if (findBy != null && StringUtils.isNotEmpty((CharSequence)findBy.timeoutInSeconds())) {
            return Optional.of((Object)Integer.valueOf(findBy.timeoutInSeconds()));
        }
        return Optional.absent();
    }

    @Override
    public WebElement findElement() {
        if (this.aPreviousStepHasFailed()) {
            return new WebElementFacadeStub();
        }
        if (this.shouldFindElementImmediately()) {
            return this.findElementImmediately();
        }
        return this.ajaxFindElement();
    }

    @Override
    @Deprecated
    public void setTimeOutInSeconds(int timeOutInSeconds) {
    }

    private boolean shouldFindElementImmediately() {
        return MethodTiming.forThisThread().isInQuickMethod();
    }

    public WebElement findElementImmediately() {
        WebElement element;
        SmartAnnotations annotations = new SmartAnnotations(this.field, this.platform);
        By by = annotations.buildBy();
        if (this.searchContext instanceof ConfigurableTimeouts) {
            ((ConfigurableTimeouts)this.searchContext).setImplicitTimeout(ZERO_SECONDS);
        }
        try {
            element = this.searchContext.findElement(by);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (this.searchContext instanceof ConfigurableTimeouts) {
                ((ConfigurableTimeouts)this.searchContext).resetTimeouts();
            }
        }
        if (element == null) {
            throw new NoSuchElementException("No such element found for criteria " + by.toString());
        }
        return element;
    }

    protected boolean isElementUsable(WebElement element) {
        return element != null && element.isDisplayed();
    }

    public WebElement ajaxFindElement() {
        SlowLoadingElement loadingElement = new SlowLoadingElement(this.clock, (Integer)this.annotatedTimeoutInSeconds.or((Object)this.getTimeOutInSeconds()));
        try {
            return ((SlowLoadingElement)loadingElement.get()).getElement();
        }
        catch (ElementNotVisibleAfterTimeoutError notVisible) {
            throw new ElementNotVisibleException(String.format("Timed out after %d seconds. %s", this.annotatedTimeoutInSeconds.or((Object)this.getTimeOutInSeconds()), notVisible.getMessage()), notVisible.getCause());
        }
        catch (Error e) {
            throw new NoSuchElementException(String.format("Timed out after %d seconds. %s", this.annotatedTimeoutInSeconds.or((Object)this.getTimeOutInSeconds()), e.getMessage()));
        }
    }

    private int getTimeOutInSeconds() {
        return (int)ThucydidesWebdriverManager.inThisTestThread().getCurrentImplicitTimeout().in(TimeUnit.SECONDS);
    }

    @Override
    public List<WebElement> findElements() {
        if (this.aPreviousStepHasFailed()) {
            return EMPTY_LIST_OF_WEBELEMENTS;
        }
        SlowLoadingElementList list = new SlowLoadingElementList(this.clock, (Integer)this.annotatedTimeoutInSeconds.or((Object)this.getTimeOutInSeconds()));
        try {
            return ((SlowLoadingElementList)list.get()).getElements();
        }
        catch (Error e) {
            throw new NoSuchElementException(String.format("Timed out after %d seconds. %s", this.annotatedTimeoutInSeconds.or((Object)this.getTimeOutInSeconds()), e.getMessage()), e.getCause());
        }
    }

    private boolean aPreviousStepHasFailed() {
        return StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed();
    }

    protected long sleepFor() {
        return 250L;
    }

    public String toString() {
        SmartAnnotations annotations = new SmartAnnotations(this.field, this.platform);
        By by = annotations.buildBy();
        return by.toString();
    }

    private class SlowLoadingElementList
    extends SlowLoadableComponent<SlowLoadingElementList> {
        private Optional<WebDriverException> lastException;
        private List<WebElement> elements;

        public SlowLoadingElementList(Clock clock, int timeOutInSeconds) {
            super(clock, timeOutInSeconds);
            this.lastException = Optional.absent();
        }

        protected void load() {
            this.lastException = Optional.absent();
            if (this.elements == null) {
                try {
                    this.elements = SmartAjaxElementLocator.super.findElements();
                }
                catch (WebDriverException e) {
                    this.lastException = Optional.of((Object)((Object)e));
                }
            }
        }

        protected long sleepFor() {
            return SmartAjaxElementLocator.this.sleepFor();
        }

        protected void isLoaded() throws Error {
            if (this.elements == null) {
                this.load();
            }
            if (!this.areElementsUsable(this.elements)) {
                if (this.lastException.isPresent()) {
                    throw new ElementNotFoundAfterTimeoutError("List elements not found", (Throwable)this.lastException.get());
                }
                throw new ElementNotVisibleAfterTimeoutError("List elements not visible");
            }
        }

        private boolean areElementsUsable(List<WebElement> elements) {
            if (elements == null) {
                return false;
            }
            for (WebElement element : elements) {
                if (SmartAjaxElementLocator.this.isElementUsable(element)) continue;
                return false;
            }
            return true;
        }

        public List<WebElement> getElements() {
            return this.elements;
        }
    }

    private class SlowLoadingElement
    extends SlowLoadableComponent<SlowLoadingElement> {
        private Optional<WebDriverException> lastException;
        private WebElement element;

        public SlowLoadingElement(Clock clock, int timeOutInSeconds) {
            super(clock, timeOutInSeconds);
            this.lastException = Optional.absent();
        }

        protected void load() {
            this.lastException = Optional.absent();
            if (this.element == null) {
                try {
                    this.element = SmartAjaxElementLocator.super.findElement();
                }
                catch (WebDriverException e) {
                    this.lastException = Optional.of((Object)((Object)e));
                }
            }
        }

        protected long sleepFor() {
            return SmartAjaxElementLocator.this.sleepFor();
        }

        protected void isLoaded() throws Error {
            if (this.element != null) {
                this.load();
            }
            if (!SmartAjaxElementLocator.this.isElementUsable(this.element)) {
                if (this.lastException.isPresent()) {
                    throw new ElementNotFoundAfterTimeoutError("Element not found", (Throwable)this.lastException.get());
                }
                throw new ElementNotVisibleAfterTimeoutError("Element not available");
            }
        }

        public WebElement getElement() {
            return this.element;
        }
    }
}

