/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.json;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestLoader;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.json.JSONConverter;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONTestOutcomeReporter
implements AcceptanceTestReporter,
AcceptanceTestLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONTestOutcomeReporter.class);
    private File outputDirectory;
    private transient String qualifier;
    private final EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
    private final String encoding = ThucydidesSystemProperty.THUCYDIDES_REPORT_ENCODING.from(this.environmentVariables, StandardCharsets.UTF_8.name());
    JSONConverter jsonConverter = (JSONConverter)Injectors.getInjector().getInstance(JSONConverter.class);

    @Override
    public String getName() {
        return "json";
    }

    @Override
    public File generateReportFor(TestOutcome testOutcome, TestOutcomes allTestOutcomes) throws IOException {
        TestOutcome storedTestOutcome = testOutcome.withQualifier(this.qualifier);
        Preconditions.checkNotNull((Object)this.outputDirectory);
        String reportFilename = this.reportFor(storedTestOutcome);
        String unique = UUID.randomUUID().toString();
        File temporary = new File(this.getOutputDirectory(), reportFilename.concat(unique));
        File report = new File(this.getOutputDirectory(), reportFilename);
        report.createNewFile();
        LOGGER.debug("Generating JSON report for {} to file {} (using temp file {})", new Object[]{testOutcome.getTitle(), report.getAbsolutePath(), temporary.getAbsolutePath()});
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(temporary));){
            this.jsonConverter.toJson(storedTestOutcome, outputStream);
            ((OutputStream)outputStream).flush();
        }
        Files.move(temporary.toPath(), report.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        return report;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    private String reportFor(TestOutcome testOutcome) {
        return testOutcome.withQualifier(this.qualifier).getReportName(ReportType.JSON);
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public void setResourceDirectory(String resourceDirectoryPath) {
    }

    @Override
    public Optional<TestOutcome> loadReportFrom(Path reportFile) {
        return this.loadReportFrom(reportFile.toFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<TestOutcome> loadReportFrom(File reportFile) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(reportFile), this.encoding));){
            TestOutcome fromJson = this.jsonConverter.fromJson(in);
            Optional optional = Optional.fromNullable((Object)fromJson);
            return optional;
        }
        catch (Throwable e) {
            LOGGER.warn("This file was not a valid JSON Serenity test report: " + reportFile.getName() + System.lineSeparator() + e.getMessage());
            return Optional.absent();
        }
    }

    @Override
    public List<TestOutcome> loadReportsFrom(Path outputDirectory) {
        return this.loadReportsFrom(outputDirectory.toFile());
    }

    @Override
    public List<TestOutcome> loadReportsFrom(File outputDirectory) {
        File[] reportFiles = this.getAllJsonFilesFrom(outputDirectory);
        ArrayList testOutcomes = Lists.newArrayList();
        if (reportFiles != null) {
            for (File reportFile : reportFiles) {
                testOutcomes.addAll(this.loadReportFrom(reportFile).asSet());
            }
        }
        return testOutcomes;
    }

    private File[] getAllJsonFilesFrom(File reportsDirectory) {
        return reportsDirectory.listFiles(new JsonFilenameFilter());
    }

    @Override
    public Optional<OutcomeFormat> getFormat() {
        return Optional.of((Object)((Object)OutcomeFormat.JSON));
    }

    private static final class JsonFilenameFilter
    implements FilenameFilter {
        private JsonFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String filename) {
            return filename.toLowerCase(Locale.getDefault()).endsWith(".json");
        }
    }
}

