/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.photography.resizing;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.serenitybdd.core.photography.PhotoFilter;
import net.serenitybdd.core.photography.ScreenshotNegative;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.Dimension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resizer
implements PhotoFilter {
    private final EnvironmentVariables environmentVariables;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public Resizer() {
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
    }

    @Override
    public Path amendedScreenshotPath(ScreenshotNegative negative) {
        return negative.getScreenshotPath();
    }

    @Override
    public ScreenshotNegative process(ScreenshotNegative negative) {
        ScreenshotNegative amendedNegative = negative.withScreenshotPath(this.amendedScreenshotPath(negative));
        try {
            this.saveResizedScreenshotTo(amendedNegative.getTemporaryPath());
        }
        catch (IOException e) {
            this.LOGGER.warn("Could not save resized screenshot", (Throwable)e);
        }
        return amendedNegative;
    }

    private void saveResizedScreenshotTo(Path temporaryPath) throws IOException {
        BufferedImage resizedImage;
        try (InputStream images = Files.newInputStream(temporaryPath, new OpenOption[0]);){
            BufferedImage image = ImageIO.read(images);
            Dimension imageSize = this.sizeOf(image);
            Dimension targetSize = this.targetSizeInProportionTo(imageSize);
            if (imageSize.equals((Object)targetSize)) {
                return;
            }
            resizedImage = this.resize(image, targetSize.width, targetSize.height);
        }
        var4_3 = null;
        try (OutputStream resizedImageStream = Files.newOutputStream(temporaryPath, new OpenOption[0]);){
            ImageIO.write((RenderedImage)resizedImage, "png", resizedImageStream);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }

    private Dimension targetSizeInProportionTo(Dimension imageSize) {
        int targetWidth = this.getResizedWidth();
        int targetHeight = (int)((double)targetWidth / (double)imageSize.width * (double)imageSize.height);
        return new Dimension(targetWidth, targetHeight);
    }

    private Dimension sizeOf(BufferedImage image) {
        return new Dimension(image.getData().getWidth(), image.getData().getHeight());
    }

    private BufferedImage resize(BufferedImage image, int width, int height) {
        int type = image.getType() == 0 ? 2 : image.getType();
        BufferedImage resizedImage = new BufferedImage(width, height, type);
        Graphics2D g = resizedImage.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    private int getResizedWidth() {
        return ThucydidesSystemProperty.THUCYDIDES_RESIZED_IMAGE_WIDTH.integerFrom(this.environmentVariables, 960);
    }
}

