/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.servicepools;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.os.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverServiceExecutable {
    private final String exeName;
    private final String exeProperty;
    private final String documentationUrl;
    private final String downloadUrl;
    private final EnvironmentVariables environmentVariables;
    private final boolean reportMissingBinary;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public DriverServiceExecutable(String exeName, String exeProperty, String documentationUrl, String downloadUrl, EnvironmentVariables environmentVariables, boolean checkExecutable) {
        this.exeName = exeName;
        this.exeProperty = exeProperty;
        this.documentationUrl = documentationUrl;
        this.downloadUrl = downloadUrl;
        this.environmentVariables = environmentVariables;
        this.reportMissingBinary = checkExecutable;
    }

    public static DriverServiceExecutableBuilder called(String exeName) {
        return new DriverServiceExecutableBuilder(exeName);
    }

    public File asAFile() {
        File executableLocation;
        Optional defaultPath = Optional.fromNullable((Object)CommandLine.find((String)this.exeName));
        Optional configuredBinaryPath = Optional.fromNullable((Object)this.environmentVariables.getProperty(this.exeProperty));
        String exePath = (String)configuredBinaryPath.or(defaultPath).orNull();
        File file = executableLocation = exePath != null ? new File(exePath) : null;
        if (this.reportMissingBinary) {
            this.checkForMissingBinaries(executableLocation);
        }
        return executableLocation;
    }

    private void checkForMissingBinaries(File executableLocation) {
        String documentationSource = (String)Optional.fromNullable((Object)this.documentationUrl).or((Object)this.downloadUrl);
        Preconditions.checkState((executableLocation != null ? 1 : 0) != 0, (String)"The path to the %s driver executable must be set by the %s system property; for more information, see %s. The latest version can be downloaded from %s", (Object[])new Object[]{this.exeName, this.exeProperty, documentationSource, this.downloadUrl});
        DriverServiceExecutable.checkExecutable(executableLocation);
    }

    protected static void checkExecutable(File exe) {
        Preconditions.checkState((boolean)exe.exists(), (String)"The driver executable does not exist: %s", (Object[])new Object[]{exe.getAbsolutePath()});
        Preconditions.checkState((!exe.isDirectory() ? 1 : 0) != 0, (String)"The driver executable is a directory: %s", (Object[])new Object[]{exe.getAbsolutePath()});
        Preconditions.checkState((boolean)FileHandler.canExecute((File)exe), (String)"The driver is not executable: %s", (Object[])new Object[]{exe.getAbsolutePath()});
    }

    public static class DriverServiceExecutableBuilder {
        private final String exeName;
        private String exeProperty;
        private String documentationUrl;
        private Optional<EnvironmentVariables> environmentVariables = Optional.absent();
        private boolean reportMissingBinary = false;

        public DriverServiceExecutableBuilder(String exeName) {
            this.exeName = exeName;
        }

        public DriverServiceExecutableBuilder withSystemProperty(String environmentProperty) {
            this.exeProperty = environmentProperty;
            return this;
        }

        public DriverServiceExecutableBuilder documentedAt(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public DriverServiceExecutableBuilder reportMissingBinary() {
            this.reportMissingBinary = true;
            return this;
        }

        public DriverServiceExecutable downloadableFrom(String downloadUrl) {
            return new DriverServiceExecutable(this.exeName, this.exeProperty, this.documentationUrl, downloadUrl, (EnvironmentVariables)this.environmentVariables.or(Injectors.getInjector().getInstance(EnvironmentVariables.class)), this.reportMissingBinary);
        }

        public DriverServiceExecutableBuilder usingEnvironmentVariables(EnvironmentVariables environmentVariables) {
            this.environmentVariables = Optional.of((Object)environmentVariables);
            return this;
        }
    }
}

