/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers.dates;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.thucydides.core.matchers.dates.DateComparator;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.DateTime;

public class DateTimeCollectionContainsSameDatesMatcher
extends TypeSafeMatcher<Collection<DateTime>> {
    private final Collection<DateTime> expectedDates;

    public DateTimeCollectionContainsSameDatesMatcher(Collection<DateTime> expectedDates) {
        this.expectedDates = expectedDates;
    }

    public boolean matchesSafely(Collection<DateTime> dates) {
        if (dates.size() != this.expectedDates.size()) {
            return false;
        }
        for (DateTime expectedDate : this.expectedDates) {
            if (this.hasIdenticalDate(expectedDate, dates)) continue;
            return false;
        }
        return true;
    }

    private boolean hasIdenticalDate(DateTime expectedDate, Collection<DateTime> dates) {
        for (DateTime date : dates) {
            if (!DateComparator.sameDate(date, expectedDate)) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a collection of dates containing ");
        List dates = Lambda.convert(this.expectedDates, this.toReadableForm());
        description.appendText("[" + Lambda.join((Object)dates) + "]");
    }

    private Converter<DateTime, String> toReadableForm() {
        return new Converter<DateTime, String>(){

            public String convert(DateTime from) {
                return from.toString("d MMM yyyy HH:mm:ss", Locale.ENGLISH);
            }
        };
    }
}

