/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.BaseReportingTask;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportProperties;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.util.EnvironmentVariables;

public class AggregateReportingTask
extends BaseReportingTask
implements ReportingTask {
    private static final String HOME_PAGE_TEMPLATE_PATH = "freemarker/home.ftl";
    private static final String BUILD_INFO_TEMPLATE_PATH = "freemarker/build-info.ftl";
    private RequirementsService requirementsService;

    public AggregateReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory) {
        this(freemarker, environmentVariables, (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class), outputDirectory);
    }

    public AggregateReportingTask(FreemarkerContext context, EnvironmentVariables environmentVariables, RequirementsService requirementsService, File outputDirectory) {
        super(context, environmentVariables, outputDirectory);
        this.requirementsService = requirementsService;
    }

    @Override
    public void generateReportsFor(TestOutcomes testOutcomes) throws IOException {
        Stopwatch stopwatch = Stopwatch.started();
        ReportNameProvider defaultNameProvider = new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirementsService);
        Map<String, Object> context = this.freemarker.getBuildContext(testOutcomes, defaultNameProvider, true);
        context.put("report", ReportProperties.forAggregateResultsReport());
        context.put("csvReport", "results.csv");
        this.generateReportPage(context, HOME_PAGE_TEMPLATE_PATH, "index.html");
        this.generateReportPage(context, BUILD_INFO_TEMPLATE_PATH, "build-info.html");
        this.generateCSVReportFor(testOutcomes, "results.csv");
        LOGGER.debug("Aggregate reports generated in {} ms ", (Object)stopwatch.stop());
    }
}

