/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.reports.html.TagReportingTask;
import net.thucydides.core.util.EnvironmentVariables;

public class AssociatedTagReportingTask
extends TagReportingTask
implements ReportingTask {
    final int batchNumber;
    final int totalBatches;

    public AssociatedTagReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportName) {
        this(freemarker, environmentVariables, outputDirectory, reportName, 1, 1);
    }

    public AssociatedTagReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportName, int batchNumber, int totalBatches) {
        super(freemarker, environmentVariables, outputDirectory, reportName);
        this.batchNumber = batchNumber;
        this.totalBatches = totalBatches;
    }

    @Override
    public void generateReportsFor(TestOutcomes testOutcomes) throws IOException {
        Stopwatch stopwatch = Stopwatch.started();
        int tagCounter = 0;
        int doneCounter = 0;
        for (TestTag tag : testOutcomes.getTags()) {
            if (tagCounter % this.totalBatches == this.batchNumber - 1) {
                this.generateAssociatedTagReportsForTag(testOutcomes.withTag(tag), tag.getName());
                ++doneCounter;
            }
            ++tagCounter;
        }
        LOGGER.trace("Associate tag reports generated for batch {} ({} tags): {} ms", new Object[]{this.batchNumber, doneCounter, stopwatch.stop()});
    }

    private void generateAssociatedTagReportsForTag(TestOutcomes testOutcomes, String sourceTag) throws IOException {
        ReportNameProvider reportName = new ReportNameProvider(sourceTag);
        for (TestTag tag : testOutcomes.getTags()) {
            this.generateTagReport(testOutcomes, reportName, tag);
        }
    }

    public AssociatedTagReportingTask forBatch(int batchNumber, int totalBatches) {
        return new AssociatedTagReportingTask(this.freemarker, this.environmentVariables, this.outputDirectory, this.reportNameProvider, batchNumber, totalBatches);
    }
}

