/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.AddBreadcrumbs;
import net.thucydides.core.reports.html.BaseReportingTask;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportProperties;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.util.EnvironmentVariables;

public class TagReportingTask
extends BaseReportingTask
implements ReportingTask {
    private static final String TEST_OUTCOME_TEMPLATE_PATH = "freemarker/home.ftl";
    protected ReportNameProvider reportNameProvider;
    Set<String> tagReportTally = Sets.newConcurrentHashSet();

    public TagReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider) {
        super(freemarker, environmentVariables, outputDirectory);
        this.reportNameProvider = reportNameProvider;
    }

    @Override
    public void generateReportsFor(TestOutcomes testOutcomes) throws IOException {
        Stopwatch stopwatch = Stopwatch.started();
        for (TestTag tag : testOutcomes.getTags()) {
            this.generateTagReport(testOutcomes, this.reportNameProvider, tag);
        }
        LOGGER.trace("Tag reports generated: {} ms", (Object)stopwatch.stop());
    }

    void generateTagReport(TestOutcomes testOutcomes, ReportNameProvider reportName, TestTag tag) throws IOException {
        String tagName = reportName.getContext() + ":" + tag;
        if (!this.tagReportTally.contains(tagName)) {
            this.tagReportTally.add(tagName);
            TestOutcomes testOutcomesForTag = testOutcomes.withTag(tag);
            Map<String, Object> context = this.freemarker.getBuildContext(testOutcomesForTag, reportName, true);
            context.put("report", ReportProperties.forTagResultsReport());
            context.put("currentTagType", tag.getType());
            context.put("currentTag", tag);
            String csvReport = reportName.forCSVFiles().forTag(tag);
            context.put("csvReport", csvReport);
            AddBreadcrumbs.forRequirementsTag(context, testOutcomes, tag);
            String report = reportName.forTag(tag);
            this.generateReportPage(context, TEST_OUTCOME_TEMPLATE_PATH, report);
            this.generateCSVReportFor(testOutcomesForTag, csvReport);
            if (this.shouldGenerateLinkableReportsFor(tag, reportName)) {
                String linkableReport = reportName.inLinkableForm().forTag(tag);
                this.generateReportPage(context, TEST_OUTCOME_TEMPLATE_PATH, linkableReport);
            }
        }
    }

    private boolean shouldGenerateLinkableReportsFor(TestTag tag, ReportNameProvider reportName) {
        List linkableTags = Splitter.on((String)",").trimResults().splitToList((CharSequence)ThucydidesSystemProperty.SERENITY_LINKED_TAGS.from(this.environmentVariables, "").toLowerCase());
        return reportName.getContext().isEmpty() && this.containsTag(linkableTags, tag.getType().toLowerCase());
    }

    private boolean containsTag(List<String> linkableTags, String tag) {
        for (String linkableTag : linkableTags) {
            if (!linkableTag.equalsIgnoreCase(tag)) continue;
            return true;
        }
        return false;
    }
}

