/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.Narrative;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.AbstractRequirementsTagProvider;
import net.thucydides.core.requirements.AllRequirements;
import net.thucydides.core.requirements.CouldNotLoadRequirementsException;
import net.thucydides.core.requirements.DisabledRequirementsStore;
import net.thucydides.core.requirements.FileSystemRequirementsStore;
import net.thucydides.core.requirements.OverridableTagProvider;
import net.thucydides.core.requirements.RequirementTypesProvider;
import net.thucydides.core.requirements.RequirementsList;
import net.thucydides.core.requirements.RequirementsStore;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.annotations.ClassInfoAnnotations;
import net.thucydides.core.requirements.classpath.LeafRequirementAdder;
import net.thucydides.core.requirements.classpath.NonLeafRequirementsAdder;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.junit.runner.RunWith;

public class PackageRequirementsTagProvider
extends AbstractRequirementsTagProvider
implements RequirementsTagProvider,
OverridableTagProvider,
RequirementTypesProvider {
    private final EnvironmentVariables environmentVariables;
    private final String rootPackage;
    private List<Requirement> requirements;
    private final RequirementsStore requirementsStore;
    private final List<Requirement> NO_REQUIREMENTS = Lists.newArrayList();
    List<String> requirementPaths;

    public PackageRequirementsTagProvider(EnvironmentVariables environmentVariables, String rootPackage, RequirementsStore requirementsStore) {
        super(environmentVariables);
        this.environmentVariables = environmentVariables;
        this.rootPackage = rootPackage;
        this.requirementsStore = requirementsStore;
    }

    public PackageRequirementsTagProvider(EnvironmentVariables environmentVariables, String rootPackage) {
        this(environmentVariables, rootPackage, new FileSystemRequirementsStore(PackageRequirementsTagProvider.getRequirementsDirectory(((Configuration)Injectors.getInjector().getInstance(Configuration.class)).getOutputDirectory()), rootPackage + "-package-requirements.json"));
    }

    public PackageRequirementsTagProvider(EnvironmentVariables environmentVariables) {
        this(environmentVariables, ThucydidesSystemProperty.THUCYDIDES_TEST_ROOT.from(environmentVariables));
    }

    public PackageRequirementsTagProvider() {
        this((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public void clear() {
        this.requirementsStore.clear();
    }

    public PackageRequirementsTagProvider withCacheDisabled() {
        return new PackageRequirementsTagProvider(this.environmentVariables, this.rootPackage, new DisabledRequirementsStore());
    }

    @Override
    public List<Requirement> getRequirements() {
        if (this.rootPackage == null) {
            return this.NO_REQUIREMENTS;
        }
        if (this.requirements == null) {
            this.fetchRequirements();
        }
        return this.requirements;
    }

    private void fetchRequirements() {
        this.requirements = (List)this.reloadedRequirements().or(this.requirementsReadFromClasspath().or(this.NO_REQUIREMENTS));
    }

    private Optional<List<Requirement>> reloadedRequirements() {
        try {
            return this.requirementsStore.read();
        }
        catch (IOException e) {
            return Optional.absent();
        }
    }

    private Optional<List<Requirement>> requirementsReadFromClasspath() {
        ArrayList classpathRequirements = null;
        try {
            List<String> requirementPaths = this.requirementPathsStartingFrom(this.rootPackage);
            Collections.sort(requirementPaths, this.byDescendingPackageLength());
            int requirementsDepth = this.longestPathIn(requirementPaths);
            Set<Object> allRequirements = Sets.newHashSet();
            for (String path : requirementPaths) {
                this.addRequirementsDefinedIn(path, requirementsDepth, allRequirements);
            }
            if (!(allRequirements = this.removeChildrenFromTopLevelRequirementsIn((Set<Requirement>)allRequirements)).isEmpty()) {
                classpathRequirements = Lists.newArrayList(allRequirements);
                Collections.sort(classpathRequirements);
                this.requirementsStore.write(classpathRequirements);
            }
        }
        catch (IOException e) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)classpathRequirements);
    }

    private Comparator<? super String> byDescendingPackageLength() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer o1Length = Splitter.on((String)".").splitToList((CharSequence)o1).size();
                Integer o2Length = Splitter.on((String)".").splitToList((CharSequence)o2).size();
                return o1Length.compareTo(o2Length);
            }
        };
    }

    private List<String> requirementPathsStartingFrom(String rootPackage) {
        if (this.requirementPaths == null) {
            this.requirementPaths = this.requirementPathsFromClassesInPackage(rootPackage);
        }
        return this.requirementPaths;
    }

    private List<String> requirementPathsFromClassesInPackage(String rootPackage) {
        ClassPath classpath;
        ArrayList requirementPaths = Lists.newArrayList();
        try {
            classpath = ClassPath.from((ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (IOException e) {
            throw new CouldNotLoadRequirementsException(e);
        }
        for (ClassPath.ClassInfo classInfo : classpath.getTopLevelClassesRecursive(rootPackage)) {
            if (!this.classRepresentsARequirementIn(classInfo)) continue;
            requirementPaths.add(classInfo.getName());
        }
        return requirementPaths;
    }

    private boolean classRepresentsARequirementIn(ClassPath.ClassInfo classInfo) {
        return ClassInfoAnnotations.theClassDefinedIn(classInfo).hasAnAnnotation(RunWith.class, Narrative.class) || ClassInfoAnnotations.theClassDefinedIn(classInfo).hasAPackageAnnotation(Narrative.class) || ClassInfoAnnotations.theClassDefinedIn(classInfo).containsTests();
    }

    private Set<Requirement> removeChildrenFromTopLevelRequirementsIn(Set<Requirement> allRequirements) {
        HashSet prunedRequirements = Sets.newHashSet();
        for (Requirement requirement : allRequirements) {
            if (requirement.getParent() != null) continue;
            prunedRequirements.add(requirement);
        }
        return prunedRequirements;
    }

    private int longestPathIn(List<String> requirementPaths) {
        int maxDepth = 0;
        for (String path : requirementPaths) {
            String pathWithoutRootPackage = path.replace(this.rootPackage + ".", "");
            int pathDepth = Splitter.on((String)".").splitToList((CharSequence)pathWithoutRootPackage).size();
            if (pathDepth <= maxDepth) continue;
            maxDepth = pathDepth;
        }
        return Math.min(maxDepth, this.requirementsConfiguration.getRequirementTypes().size());
    }

    private void addRequirementsDefinedIn(String path, int requirementsDepth, Collection<Requirement> allRequirements) {
        Requirement leafRequirement = LeafRequirementAdder.addLeafRequirementDefinedIn(path).withAMaximumRequirementsDepthOf(requirementsDepth).usingRequirementTypes(this.getActiveRequirementTypes()).startingAt(this.rootPackage).to(allRequirements);
        NonLeafRequirementsAdder.addParentsOf(leafRequirement).in(path).withAMaximumRequirementsDepthOf(requirementsDepth).startingAt(this.rootPackage).to(allRequirements);
    }

    @Override
    public Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome) {
        return this.getTestCaseRequirementOf(testOutcome);
    }

    public Optional<Requirement> getTestCaseRequirementOf(TestOutcome testOutcome) {
        for (Requirement requirement : AllRequirements.in(this.getRequirements())) {
            if (!requirement.asTag().isAsOrMoreSpecificThan(testOutcome.getUserStory().asTag())) continue;
            return Optional.of((Object)requirement);
        }
        return Optional.absent();
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag testTag) {
        for (Requirement requirement : AllRequirements.in(this.getRequirements())) {
            if (!requirement.asTag().isAsOrMoreSpecificThan(testTag)) continue;
            return Optional.of((Object)requirement);
        }
        return this.uniqueRequirementWithName(testTag.getName());
    }

    private Optional<Requirement> uniqueRequirementWithName(String name) {
        return RequirementsList.of(this.getRequirements()).findByUniqueName(name);
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        if (testOutcome.getUserStory() == null) {
            return Sets.newHashSet();
        }
        HashSet<TestTag> tags = new HashSet<TestTag>();
        Optional<Requirement> matchingRequirement = this.getRequirementFor(testOutcome.getUserStory().asTag());
        if (matchingRequirement.isPresent()) {
            tags.add(((Requirement)matchingRequirement.get()).asTag());
            Optional<Requirement> parent = this.parentOf((Requirement)matchingRequirement.get());
            while (parent.isPresent()) {
                tags.add(((Requirement)parent.get()).asTag());
                parent = this.parentOf((Requirement)parent.get());
            }
        }
        return tags;
    }

    private Optional<Requirement> parentOf(Requirement child) {
        for (Requirement requirement : AllRequirements.in(this.requirements)) {
            if (!requirement.getChildren().contains(child)) continue;
            return Optional.of((Object)requirement);
        }
        return Optional.absent();
    }

    private static File getRequirementsDirectory(File directory) {
        return new File(directory, "requirements");
    }

    public void clearCache() {
        this.requirementsStore.clear();
    }

    @Override
    public List<String> getActiveRequirementTypes() {
        List<String> allRequirementTypes = this.requirementsConfiguration.getRequirementTypes();
        int maxDepth = this.longestPathIn(this.requirementPathsStartingFrom(this.rootPackage));
        return this.applicableRequirements(allRequirementTypes, maxDepth);
    }

    private List<String> applicableRequirements(List<String> allRequirementTypes, int maxDepth) {
        int startingLevel = Math.max(allRequirementTypes.size() - maxDepth, 0);
        int endingLevel = allRequirementTypes.size();
        return allRequirementTypes.subList(startingLevel, endingLevel);
    }
}

