/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.requirements.model.Narrative;
import org.apache.commons.lang3.StringUtils;

public class LoadedNarrative {
    Optional<String> TYPE_UNDEFINED = Optional.absent();

    public static LoadedNarrative load() {
        return new LoadedNarrative();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Narrative> fromFile(File narrativeFile, String defaultType) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(narrativeFile), StandardCharsets.UTF_8));){
            List<String> lines = this.readPreambleFrom(reader);
            String title = null;
            String type = defaultType;
            String cardNumber = this.findCardNumberIn(lines);
            List<String> versionNumbers = this.findVersionNumberIn(lines);
            Optional<String> titleLine = this.readOptionalTitleFrom(lines);
            if (titleLine.isPresent()) {
                title = this.titleFrom((String)titleLine.get());
                type = (String)this.typeFrom((String)titleLine.get()).or((Object)defaultType);
            }
            String text = this.readNarrativeFrom(lines);
            reader.close();
            Optional optional = Optional.of((Object)new Narrative((Optional<String>)Optional.fromNullable((Object)title), (Optional<String>)Optional.fromNullable((Object)cardNumber), versionNumbers, type, text));
            return optional;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return Optional.absent();
        }
    }

    private List<String> readPreambleFrom(BufferedReader reader) throws IOException {
        ArrayList usefulLines = Lists.newArrayList();
        boolean preambleFinished = false;
        while (!preambleFinished) {
            String nextLine = reader.readLine();
            if (nextLine == null) {
                preambleFinished = true;
                continue;
            }
            if (this.preambleFinishedAt(nextLine)) {
                preambleFinished = true;
                continue;
            }
            if (!this.thereIsUsefulInformationIn(nextLine)) continue;
            usefulLines.add(nextLine);
        }
        return usefulLines;
    }

    private boolean preambleFinishedAt(String nextLine) {
        return this.normalizedLine(nextLine).startsWith("scenario") || this.normalizedLine(nextLine).startsWith("background:");
    }

    private String normalizedLine(String nextLine) {
        return nextLine.trim().toLowerCase();
    }

    private boolean thereIsUsefulInformationIn(String nextLine) {
        String normalizedText = this.normalizedLine(nextLine);
        return !normalizedText.isEmpty() && !normalizedText.startsWith("#") && !normalizedText.startsWith("meta:") && !normalizedText.startsWith("background:") && (!normalizedText.startsWith("@") || normalizedText.startsWith("@issue") || normalizedText.startsWith("@versions"));
    }

    private String findCardNumberIn(List<String> lines) {
        String cardNumber = null;
        for (String line : lines) {
            String issueNumber;
            String normalizedLine = line.toUpperCase();
            if (normalizedLine.startsWith("@ISSUES")) {
                String issueList = normalizedLine.replace("@ISSUES", "").trim();
                ArrayList issues = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)issueList));
                if (issues.isEmpty()) continue;
                cardNumber = (String)issues.get(0);
                continue;
            }
            if (!normalizedLine.startsWith("@ISSUE") || StringUtils.isEmpty((CharSequence)(issueNumber = normalizedLine.replace("@ISSUE", "").trim()))) continue;
            cardNumber = issueNumber;
        }
        return cardNumber;
    }

    private List<String> findVersionNumberIn(List<String> lines) {
        for (String line : lines) {
            String normalizedLine = line.toUpperCase();
            if (!normalizedLine.startsWith("@VERSIONS")) continue;
            String versionList = line.substring("@VERSIONS".length()).trim();
            return Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)versionList));
        }
        return ImmutableList.of();
    }

    private String readNarrativeFrom(List<String> lines) {
        StringBuilder description = new StringBuilder();
        for (String line : lines) {
            if (this.isMarkup(line) || this.isAnnotation(line) || this.isComment(line)) continue;
            description.append(line.trim());
            description.append(System.lineSeparator());
        }
        return description.toString().trim();
    }

    private boolean isAnnotation(String line) {
        return this.normalizedLine(line).startsWith("@");
    }

    private Optional<String> readOptionalTitleFrom(List<String> lines) {
        String firstLine;
        if (!lines.isEmpty() && !this.isMarkup(firstLine = lines.get(0))) {
            Optional title = Optional.of((Object)this.stripFeatureFrom(firstLine));
            lines.remove(0);
            return title;
        }
        return Optional.absent();
    }

    private boolean isMarkup(String line) {
        String normalizedLine = this.normalizedLine(line);
        return normalizedLine.startsWith("narrative:") || normalizedLine.startsWith("givenstory:") || normalizedLine.startsWith("background:") || normalizedLine.startsWith("meta") || normalizedLine.startsWith("@") || normalizedLine.startsWith("givenstories:");
    }

    private String stripFeatureFrom(String firstLine) {
        return firstLine.toLowerCase().startsWith("feature:") ? firstLine.substring(8).trim() : firstLine;
    }

    private boolean isComment(String line) {
        return line.startsWith("#");
    }

    private String titleFrom(String titleLine) {
        return titleLine.contains(":") ? titleLine.substring(titleLine.indexOf(":") + 1) : titleLine;
    }

    private Optional<String> typeFrom(String titleLine) {
        if (titleLine.contains(":")) {
            String featureNameSection = titleLine.substring(0, titleLine.indexOf(":"));
            String featureName = featureNameSection.split("\\s")[0];
            return Optional.of((Object)featureName.toLowerCase().trim());
        }
        return this.TYPE_UNDEFINED;
    }
}

