/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.DriverStrategySelector;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class RedimensionBrowser {
    private final EnvironmentVariables environmentVariables;
    private final Class<? extends WebDriver> driverClass;

    public RedimensionBrowser(EnvironmentVariables environmentVariables, Class<? extends WebDriver> driverClass) {
        this.environmentVariables = environmentVariables;
        this.driverClass = driverClass;
    }

    public void withDriver(WebDriver driver) {
        if (this.supportsScreenResizing(driver) && this.browserDimensionsSpecified()) {
            this.resizeBrowserTo(driver, this.getRequestedBrowserSize().height, this.getRequestedBrowserSize().width);
        }
    }

    private Dimension getRequestedBrowserSize() {
        int height = ThucydidesSystemProperty.THUCYDIDES_BROWSER_HEIGHT.integerFrom(this.environmentVariables, 700);
        int width = ThucydidesSystemProperty.THUCYDIDES_BROWSER_WIDTH.integerFrom(this.environmentVariables, 960);
        return new Dimension(width, height);
    }

    private boolean browserDimensionsSpecified() {
        String snapshotWidth = ThucydidesSystemProperty.THUCYDIDES_BROWSER_WIDTH.from(this.environmentVariables);
        String snapshotHeight = ThucydidesSystemProperty.THUCYDIDES_BROWSER_HEIGHT.from(this.environmentVariables);
        return snapshotWidth != null || snapshotHeight != null;
    }

    private boolean supportsScreenResizing(WebDriver driver) {
        boolean supportsResizing = DriverStrategySelector.inEnvironment(this.environmentVariables).supportsResizing(this.driverClass);
        return supportsResizing && this.isNotAMocked(driver);
    }

    private boolean isNotAMocked(WebDriver driver) {
        return !driver.getClass().getName().contains("Mock") && !driver.toString().contains("Mock for");
    }

    protected void resizeBrowserTo(WebDriver driver, int height, int width) {
        block2: {
            try {
                driver.manage().window().setSize(new Dimension(width, height));
                driver.manage().window().setPosition(new Point(0, 0));
            }
            catch (WebDriverException couldNotResizeScreen) {
                if (!couldNotResizeScreen.getMessage().contains("Invalid requested size")) break block2;
                this.maximiseBrowser(driver);
            }
        }
    }

    private void maximiseBrowser(WebDriver driver) {
        driver.manage().window().maximize();
    }
}

