/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SerenityWebdriverManager;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThucydidesWebDriverSupport {
    private static final ThreadLocal<WebdriverManager> webdriverManagerThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Pages> pagesThreadLocal = new ThreadLocal();
    private static final ThreadLocal<StepFactory> stepFactoryThreadLocal = new ThreadLocal();
    private static final ThreadLocal<String> defaultDriverType = new ThreadLocal();
    private static final Logger LOGGER = LoggerFactory.getLogger(ThucydidesWebDriverSupport.class);

    public static void initialize() {
        if (!ThucydidesWebDriverSupport.webdriversInitialized()) {
            ThucydidesWebDriverSupport.setWebdriverManager(ThucydidesWebDriverSupport.newWebdriverManager());
        }
    }

    public static void initialize(String requestedDriver) {
        WebdriverManager webdriverManagerForThisThread = ThucydidesWebDriverSupport.newWebdriverManager();
        ThucydidesWebDriverSupport.setWebdriverManager(webdriverManagerForThisThread);
        ThucydidesWebDriverSupport.getWebdriverManager().overrideDefaultDriverType(requestedDriver);
    }

    private static WebdriverManager newWebdriverManager() {
        WebDriverFactory webDriverFactoryForThisThread = new WebDriverFactory();
        Configuration globalConfiguration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        return new SerenityWebdriverManager(webDriverFactoryForThisThread, globalConfiguration);
    }

    public static void initialize(WebdriverManager webdriverManager, String requestedDriver) {
        ThucydidesWebDriverSupport.setupWebdriverManager(webdriverManager, requestedDriver);
        ThucydidesWebDriverSupport.initPagesObjectUsing(ThucydidesWebDriverSupport.getDriver());
    }

    public static void reset() {
        if (webdriverManagerThreadLocal.get() != null) {
            webdriverManagerThreadLocal.get().reset();
        }
        webdriverManagerThreadLocal.remove();
        pagesThreadLocal.remove();
        stepFactoryThreadLocal.remove();
        defaultDriverType.remove();
    }

    public static boolean isInitialised() {
        return webdriverManagerThreadLocal.get() != null;
    }

    private static boolean webdriversInitialized() {
        return webdriverManagerThreadLocal.get() != null;
    }

    public static void initializeFieldsIn(Object testCase) {
        ThucydidesWebDriverSupport.initialize();
        ThucydidesWebDriverSupport.getDriver();
        ThucydidesWebDriverSupport.injectDriverInto(testCase);
        ThucydidesWebDriverSupport.injectAnnotatedPagesObjectInto(testCase);
    }

    public static StepFactory getStepFactory() {
        if (pagesThreadLocal.get() == null) {
            ThucydidesWebDriverSupport.initPagesObjectUsing(ThucydidesWebDriverSupport.getDriver());
        }
        return stepFactoryThreadLocal.get();
    }

    public static void useDefaultDriver(String driverName) {
        defaultDriverType.set(driverName);
    }

    public static void clearDefaultDriver() {
        defaultDriverType.remove();
        if (webdriverManagerThreadLocal.get() != null) {
            webdriverManagerThreadLocal.get().overrideDefaultDriverType("");
        }
    }

    public static void clearSession() {
        if (ThucydidesWebDriverSupport.getWebdriverManager().getCurrentDriver() != null) {
            ThucydidesWebDriverSupport.getWebdriverManager().getCurrentDriver().manage().deleteAllCookies();
        }
    }

    public static void useDriver(WebDriver driver) {
        ThucydidesWebDriverSupport.initialize();
        ThucydidesWebDriverSupport.getWebdriverManager().registerDriver(driver);
    }

    public static WebDriver getDriver() {
        if (webdriverManagerThreadLocal.get() == null) {
            return null;
        }
        WebDriver driver = defaultDriverType.get() != null ? ThucydidesWebDriverSupport.getWebdriverManager().getWebdriver(defaultDriverType.get()) : (ThucydidesWebDriverSupport.getWebdriverManager().getCurrentDriver() != null ? ThucydidesWebDriverSupport.getWebdriverManager().getCurrentDriver() : ThucydidesWebDriverSupport.getWebdriverManager().getWebdriver());
        ThucydidesWebDriverSupport.initPagesObjectUsing(driver);
        return driver;
    }

    public static void closeAllDrivers() {
        if (ThucydidesWebDriverSupport.webdriversInitialized()) {
            ThucydidesWebDriverSupport.getWebdriverManager().closeAllDrivers();
        }
    }

    public static void closeCurrentDrivers() {
        if (ThucydidesWebDriverSupport.webdriversInitialized()) {
            ThucydidesWebDriverSupport.getWebdriverManager().closeCurrentDrivers();
        }
    }

    public static void closeDriver() {
        if (ThucydidesWebDriverSupport.webdriversInitialized()) {
            ThucydidesWebDriverSupport.getWebdriverManager().closeDriver();
        }
    }

    private static void setupWebdriverManager(WebdriverManager webdriverManager, String requestedDriver) {
        ThucydidesWebDriverSupport.setWebdriverManager(webdriverManager);
        ThucydidesWebDriverSupport.getWebdriverManager().overrideDefaultDriverType(requestedDriver);
    }

    private static void initStepFactoryUsing(Pages pagesObject) {
        stepFactoryThreadLocal.set(new StepFactory(pagesObject));
    }

    public static WebdriverManager getWebdriverManager(WebDriverFactory webDriverFactory, Configuration configuration) {
        ThucydidesWebDriverSupport.initialize(new SerenityWebdriverManager(webDriverFactory, configuration), "");
        return webdriverManagerThreadLocal.get();
    }

    public static WebdriverManager getWebdriverManager() {
        if (ThucydidesWebDriverSupport.webdriverManagerIsNotInstantiated()) {
            ThucydidesWebDriverSupport.initialize();
        }
        return webdriverManagerThreadLocal.get();
    }

    private static void initPagesObjectUsing(WebDriver driver) {
        pagesThreadLocal.set(new Pages(driver));
        ThucydidesWebDriverSupport.initStepFactoryUsing(ThucydidesWebDriverSupport.getPages());
    }

    public static Pages getPages() {
        if (pagesThreadLocal.get() == null) {
            ThucydidesWebDriverSupport.initPagesObjectUsing(ThucydidesWebDriverSupport.getDriver());
        }
        return pagesThreadLocal.get();
    }

    protected static void injectDriverInto(Object testCase) {
        TestCaseAnnotations.forTestCase(testCase).injectDrivers(ThucydidesWebDriverSupport.getDriver(), ThucydidesWebDriverSupport.getWebdriverManager());
    }

    protected static void injectAnnotatedPagesObjectInto(Object testCase) {
        StepAnnotations.injectOptionalAnnotatedPagesObjectInto(testCase, ThucydidesWebDriverSupport.getPages());
    }

    public static <T extends WebDriver> T getProxiedDriver() {
        return (T)((WebDriverFacade)ThucydidesWebDriverSupport.getDriver()).getProxiedDriver();
    }

    public static Class<? extends WebDriver> getDriverClass() {
        if (ThucydidesWebDriverSupport.getDriver() instanceof WebDriverFacade) {
            return ((WebDriverFacade)ThucydidesWebDriverSupport.getDriver()).getDriverClass();
        }
        return ThucydidesWebDriverSupport.getDriver().getClass();
    }

    public static SessionId getSessionId() {
        return ThucydidesWebDriverSupport.getWebdriverManager().getSessionId();
    }

    public static String getCurrentDriverName() {
        if (!ThucydidesWebDriverSupport.webdriversInitialized()) {
            return "";
        }
        return ThucydidesWebDriverSupport.getWebdriverManager().getCurrentDriverType();
    }

    public static String getDriversUsed() {
        if (ThucydidesWebDriverSupport.webdriverManagerIsNotInstantiated()) {
            return "";
        }
        return ThucydidesWebDriverSupport.getWebdriverManager().getActiveDriverTypes().get(0);
    }

    private static boolean webdriverManagerIsNotInstantiated() {
        return webdriverManagerThreadLocal.get() == null;
    }

    public static boolean isDriverInstantiated() {
        return ThucydidesWebDriverSupport.isInitialised() && ThucydidesWebDriverSupport.getWebdriverManager().hasAnInstantiatedDriver();
    }

    private static void setWebdriverManager(WebdriverManager webdriverManager) {
        webdriverManagerThreadLocal.set(webdriverManager);
    }
}

