/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.List;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilitiesProvider;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.chrome.OptionsSplitter;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeDriverCapabilities
implements DriverCapabilitiesProvider {
    private final EnvironmentVariables environmentVariables;

    public ChromeDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public DesiredCapabilities getCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.chrome();
        String chromeSwitches = this.environmentVariables.getProperty(ThucydidesSystemProperty.CHROME_SWITCHES);
        ChromeOptions chromeOptions = this.optionsFromSwitches(chromeSwitches);
        this.updateChromeBinaryIfSpecified(chromeOptions);
        capabilities.setCapability("chromeOptions", (Object)chromeOptions);
        capabilities.setCapability("chrome.switches", chromeSwitches);
        return capabilities;
    }

    private ChromeOptions optionsFromSwitches(String chromeSwitches) {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"test-type"});
        if (StringUtils.isNotEmpty((CharSequence)chromeSwitches)) {
            List<String> arguments = new OptionsSplitter().split(chromeSwitches);
            options.addArguments(arguments);
        }
        return options;
    }

    private void updateChromeBinaryIfSpecified(ChromeOptions options) {
        String chromeBinary = this.environmentVariables.getProperty(ThucydidesSystemProperty.WEBDRIVER_CHROME_BINARY);
        if (StringUtils.isNotEmpty((CharSequence)chromeBinary)) {
            options.setBinary(chromeBinary);
        }
    }
}

