/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.io.IOException;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.time.InternalSystemClock;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.serenitybdd.core.webdriver.servicepools.InternetExplorerServicePool;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternetExplorerDriverProvider
implements DriverProvider {
    private final EnvironmentVariables environmentVariables;
    private final CapabilityEnhancer enhancer;
    private final DriverCapabilityRecord driverProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(InternetExplorerDriverProvider.class);
    private final DriverServicePool driverServicePool = new InternetExplorerServicePool();

    private DriverServicePool getDriverServicePool() throws IOException {
        this.driverServicePool.ensureServiceIsRunning();
        return this.driverServicePool;
    }

    public InternetExplorerDriverProvider(EnvironmentVariables environmentVariables, CapabilityEnhancer enhancer) {
        this.environmentVariables = environmentVariables;
        this.enhancer = enhancer;
        this.driverProperties = (DriverCapabilityRecord)Injectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    @Override
    public WebDriver newInstance() {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        DesiredCapabilities desiredCapabilities = this.enhancer.enhanced(this.recommendedDefaultInternetExplorerCapabilities());
        this.driverProperties.registerCapabilities("iexplorer", (Capabilities)desiredCapabilities);
        try {
            return this.retryCreateDriverOnNoSuchSession(desiredCapabilities);
        }
        catch (Exception couldNotStartServer) {
            LOGGER.warn("Failed to start the Internet driver service, using a native driver instead - " + couldNotStartServer.getMessage());
            return new InternetExplorerDriver((Capabilities)desiredCapabilities);
        }
    }

    private WebDriver retryCreateDriverOnNoSuchSession(DesiredCapabilities desiredCapabilities) throws IOException {
        return new TryAtMost(3).toStartNewDriverWith(desiredCapabilities);
    }

    private DesiredCapabilities recommendedDefaultInternetExplorerCapabilities() {
        DesiredCapabilities defaults = DesiredCapabilities.internetExplorer();
        defaults.setCapability("ignoreZoomSetting", true);
        defaults.setCapability("nativeEvents", false);
        defaults.setCapability("requireWindowFocus", false);
        defaults.setCapability("takesScreenshot", true);
        defaults.setJavascriptEnabled(true);
        return defaults;
    }

    private class TryAtMost {
        private final int maxTries;

        private TryAtMost(int maxTries) {
            this.maxTries = maxTries;
        }

        public WebDriver toStartNewDriverWith(DesiredCapabilities desiredCapabilities) throws IOException {
            try {
                return InternetExplorerDriverProvider.this.getDriverServicePool().newDriver((Capabilities)desiredCapabilities);
            }
            catch (NoSuchSessionException e) {
                if (this.maxTries == 0) {
                    throw e;
                }
                LOGGER.error(((Object)((Object)e)).getClass().getCanonicalName() + " happened - retrying in 2 seconds");
                new InternalSystemClock().pauseFor(2000L);
                return new TryAtMost(this.maxTries - 1).toStartNewDriverWith(desiredCapabilities);
            }
        }
    }
}

