/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fields {
    private static final Logger LOGGER = LoggerFactory.getLogger(Fields.class);
    private final Class<?> clazz;

    public static Fields of(Class<?> testClass) {
        return new Fields(testClass);
    }

    private Fields(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Set<Field> allFields() {
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(Arrays.asList(this.clazz.getDeclaredFields()));
        fields.addAll(Arrays.asList(this.clazz.getFields()));
        if (this.clazz != Object.class) {
            fields.addAll(Fields.of(this.clazz.getSuperclass()).allFields());
        }
        return fields;
    }

    public Set<Field> declaredFields() {
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(Arrays.asList(this.clazz.getDeclaredFields()));
        return fields;
    }

    public Set<Field> nonStaticFields() {
        Set<Field> fields = this.allFields();
        HashSet<Field> nonStaticFields = new HashSet<Field>();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            nonStaticFields.add(field);
        }
        return nonStaticFields;
    }

    public Optional<Field> withName(String pages) {
        for (Field field : this.allFields()) {
            if (!field.getName().equals(pages)) continue;
            return Optional.of((Object)field);
        }
        return Optional.absent();
    }

    public Set<Field> fieldsAnnotatedBy(Class<? extends Annotation> annotationClass) {
        Set<Field> fields = this.allFields();
        HashSet<Field> annotatedFields = new HashSet<Field>();
        for (Field field : fields) {
            if (field.getAnnotation(annotationClass) == null) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    public static FieldValueBuilder of(Object object) {
        return new FieldValueBuilder(object);
    }

    public static boolean isAbstract(Field field) {
        return Modifier.isAbstract(field.getType().getModifiers());
    }

    public static boolean isFinal(Field field) {
        return Modifier.isFinal(field.getType().getModifiers());
    }

    public static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getType().getModifiers());
    }

    public static class FieldValueBuilder {
        private final Object object;

        public FieldValueBuilder(Object object) {
            this.object = object;
        }

        public Map<String, Object> asMap() {
            HashMap fieldValues = Maps.newHashMap();
            for (Field field : Fields.of(this.object.getClass()).allFields()) {
                try {
                    field.setAccessible(true);
                    if (!this.isValid(field)) continue;
                    fieldValues.put(field.getName(), this.fieldValueFrom(field).or(FieldValue.UNDEFINED));
                }
                catch (IllegalAccessException e) {
                    LOGGER.warn("Failed to inject the field " + field.getName(), (Throwable)e);
                }
            }
            fieldValues.put("self", this.object);
            fieldValues.put("this", this.object);
            return ImmutableMap.copyOf((Map)fieldValues);
        }

        private boolean isValid(Field field) {
            return field != null && !field.getName().contains("CGLIB");
        }

        private FieldValueProvider fieldValueFrom(Field field) {
            return new FieldValueProvider(field, this.object);
        }

        private static class FieldValueProvider {
            Field field;
            Object object;

            public FieldValueProvider(Field field, Object object) {
                this.field = field;
                this.object = object;
            }

            public Object or(FieldValue undefinedValue) throws IllegalAccessException {
                return this.field == null || this.object == null || this.field.get(this.object) == null ? undefinedValue : this.field.get(this.object);
            }
        }
    }

    public static enum FieldValue {
        UNDEFINED;

    }
}

