/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.configuration;

import com.google.common.base.Joiner;
import java.io.File;
import net.thucydides.core.configuration.BuildDirectoryProvider;

class MavenBuildDirectory {
    MavenBuildDirectory() {
    }

    static BuildDirectoryProvider forAMavenProject() {
        return new BuildDirectoryProvider(){

            @Override
            public String buildDirectoryFrom(String baseDirectory) {
                return Joiner.on((String)File.separator).join((Object)baseDirectory, (Object)"target", new Object[]{"site", "serenity"});
            }
        };
    }

    static BuildDirectoryProvider forAMavenProjectWithAConfiguredReportDirectoryTarget() {
        return new BuildDirectoryProvider(){

            @Override
            public String buildDirectoryFrom(String baseDirectory) {
                return Joiner.on((String)File.separator).join((Object)baseDirectory, (Object)"serenity", new Object[0]);
            }
        };
    }

    static BuildDirectoryProvider forAMavenProjectWithAConfiguredReportDirectory() {
        return new BuildDirectoryProvider(){

            @Override
            public String buildDirectoryFrom(String baseDirectory) {
                return baseDirectory;
            }
        };
    }

    static BuildDirectoryProvider forADefaultMavenConfiguration() {
        return new BuildDirectoryProvider(){

            @Override
            public String buildDirectoryFrom(String baseDirectory) {
                return Joiner.on((String)File.separator).join((Object)"target", (Object)"site", new Object[]{"serenity"});
            }
        };
    }
}

