/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.jquery;

import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.javascript.JavascriptExecutorFacade;
import net.thucydides.core.webdriver.javascript.JavascriptSupport;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JQueryEnabledPage {
    private final WebDriver driver;
    private final EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(JQueryEnabledPage.class);

    protected JQueryEnabledPage(WebDriver driver) {
        this(driver, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    protected JQueryEnabledPage(WebDriver driver, EnvironmentVariables environmentVariables) {
        this.driver = driver;
        this.environmentVariables = environmentVariables;
    }

    public static JQueryEnabledPage withDriver(WebDriver driver) {
        return new JQueryEnabledPage(driver);
    }

    public boolean isJQueryIntegrationEnabled() {
        boolean jqueryIntegrationEnabled = Boolean.valueOf(ThucydidesSystemProperty.THUCYDIDES_JQUERY_INTEGRATION.from(this.environmentVariables, "true"));
        return jqueryIntegrationEnabled;
    }

    public boolean isJQueryAvailable() {
        boolean jqueryIntegrationEnabled = this.isJQueryIntegrationEnabled();
        if (jqueryIntegrationEnabled && JavascriptSupport.javascriptIsSupportedIn(this.driver)) {
            JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
            Boolean result = (Boolean)js.executeScript("return (typeof jQuery === 'function')");
            return result != null && result != false;
        }
        return false;
    }

    public void injectJQuery() {
        this.executeScriptFrom("jquery/jquery.min.js");
        this.executeScriptFrom("jquery/jquery.focus.test-fix.js");
    }

    protected void executeScriptFrom(String scriptSource) {
        if (JavascriptSupport.javascriptIsSupportedIn(this.driver)) {
            String script = this.getFileAsString(scriptSource);
            JavascriptExecutorFacade js = new JavascriptExecutorFacade(this.driver);
            js.executeScript(script);
        }
    }

    private String getFileAsString(String resourcePath) {
        String content = "";
        try {
            URL fileUrl = this.getClass().getClassLoader().getResource(resourcePath);
            content = Resources.toString((URL)fileUrl, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return content;
    }

    public void injectJQueryPlugins() {
        if (ThucydidesSystemProperty.THUCYDIDES_ACTIVATE_HIGHLIGHTING.booleanFrom(this.environmentVariables).booleanValue()) {
            this.executeScriptFrom("jquery/jquery-thucydides-plugin.js");
        }
    }

    public void injectJavaScriptUtils() {
        this.executeScriptFrom("javascript/cycle.js");
    }

    public void activateJQuery() {
        if (this.isJQueryIntegrationEnabled() && !this.isJQueryAvailable()) {
            this.injectJQuery();
            this.injectJQueryPlugins();
        }
    }
}

