/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.beust.jcommander.internal.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.reports.NumberOfThreads;
import net.thucydides.core.reports.html.Reporter;
import net.thucydides.core.reports.html.ReportingTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportGenerator.class);
    private Stopwatch stopwatch = new Stopwatch();

    public void generateReportsFor(Collection<ReportingTask> reportingTasks) throws IOException {
        this.stopwatch.start();
        try {
            Reporter.generateReportsFor(reportingTasks);
            List partitions = Lists.newArrayList();
            for (ReportingTask reportingTask : reportingTasks) {
                partitions.add(new ReportExecutor(reportingTask));
            }
            ExecutorService executorPool = Executors.newFixedThreadPool(NumberOfThreads.forIOOperations());
            for (Future executedTask : executorPool.invokeAll(partitions)) {
                executedTask.get();
            }
        }
        catch (Exception e) {
            LOGGER.error("Report generation failed", (Throwable)e);
        }
        LOGGER.debug("Reports generated in {} ms", (Object)this.stopwatch.stop());
    }

    private class ReportExecutor
    implements Callable<Void> {
        private final ReportingTask reportingTask;

        public ReportExecutor(ReportingTask reportingTask) {
            this.reportingTask = reportingTask;
        }

        @Override
        public Void call() throws Exception {
            Stopwatch reportingStopwatch = Stopwatch.started();
            this.reportingTask.generateReports();
            LOGGER.debug("{} generated in {} ms", (Object)this.reportingTask.toString(), (Object)reportingStopwatch.stop());
            return null;
        }
    }
}

