/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.junit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.io.SafelyMoveFiles;
import net.thucydides.core.reports.junit.JUnitXMLConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitXMLOutcomeReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JUnitXMLOutcomeReporter.class);
    private final File outputDirectory;
    private final JUnitXMLConverter junitXMLConverter;
    public static final String FILE_PREFIX = "SERENITY-JUNIT-";

    public JUnitXMLOutcomeReporter(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.junitXMLConverter = new JUnitXMLConverter();
    }

    public void generateReportsFor(TestOutcomes testOutcomes) throws IOException {
        LOGGER.debug("GENERATING JUNIT REPORTS");
        Preconditions.checkNotNull((Object)this.outputDirectory);
        Map<String, List<TestOutcome>> testOutcomesGroupedByTestCase = this.groupByTestCase(testOutcomes);
        for (String testCase : testOutcomesGroupedByTestCase.keySet()) {
            List<TestOutcome> testCaseOutcomes = testOutcomesGroupedByTestCase.get(testCase);
            String reportFilename = this.reportFilenameFor(testCaseOutcomes.get(0));
            String unique = UUID.randomUUID().toString();
            File temporary = new File(this.getOutputDirectory(), reportFilename.concat(unique));
            File report = new File(this.getOutputDirectory(), reportFilename);
            report.createNewFile();
            LOGGER.debug("GENERATING JUNIT REPORT {} using temporary file {}", (Object)reportFilename, (Object)temporary);
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(temporary));){
                this.junitXMLConverter.write(testCase, testCaseOutcomes, outputStream);
                ((OutputStream)outputStream).flush();
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e);
            }
            catch (TransformerException e) {
                throw new IOException(e);
            }
            SafelyMoveFiles.withMaxRetriesOf(3).from(temporary.toPath()).to(report.toPath());
        }
    }

    private String reportFilenameFor(TestOutcome testOutcome) {
        ReportNamer reportNamer = ReportNamer.forReportType(ReportType.XML);
        return FILE_PREFIX + reportNamer.getNormalizedTestNameFor(testOutcome);
    }

    private Map<String, List<TestOutcome>> groupByTestCase(TestOutcomes testOutcomes) {
        HashMap groupedTestOutcomes = Maps.newHashMap();
        for (TestOutcome testOutcome : testOutcomes.getOutcomes()) {
            String testCaseName;
            String string = testCaseName = StringUtils.isNotEmpty((CharSequence)testOutcome.getTestCaseName()) ? testOutcome.getTestCaseName() : testOutcome.getStoryTitle();
            if (groupedTestOutcomes.containsKey(testCaseName)) {
                ((List)groupedTestOutcomes.get(testCaseName)).add(testOutcome);
                continue;
            }
            ArrayList outcomes = Lists.newArrayList();
            outcomes.add(testOutcome);
            groupedTestOutcomes.put(testCaseName, outcomes);
        }
        return groupedTestOutcomes;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    private String reportFor(TestOutcome testOutcome) {
        return "SERENITY-TEST-" + testOutcome.getReportName(ReportType.JUNIT);
    }
}

